/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component;

import com.google.common.primitives.Ints;
import joptsimple.internal.Strings;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import openmods.api.IValueReceiver;
import openmods.gui.component.BaseComponent;
import openmods.gui.listener.IValueChangedListener;
import org.lwjgl.opengl.GL11;

public class GuiComponentSlider
extends BaseComponent
implements IValueReceiver<Double> {
    private static final int HANDLE_SIZE = 8;
    private int width;
    private final double min;
    private final double max;
    private final int steps;
    private final double stepSize;
    private final boolean showValue;
    private final String label;
    private int step;
    private IValueChangedListener<Double> listener;

    public GuiComponentSlider(int x, int y, int width, int min, int max, int initialValue) {
        this(x, y, width, min, max, initialValue, max - min, true, "");
    }

    public GuiComponentSlider(int x, int y, int width, int min, int max, int initialValue, boolean showValue) {
        this(x, y, width, min, max, initialValue, max - min, showValue, "");
    }

    public GuiComponentSlider(int x, int y, int width, int min, int max, int initialValue, boolean showValue, String label) {
        this(x, y, width, min, max, initialValue, max - min, showValue, label);
    }

    public GuiComponentSlider(int x, int y, int width, double min, double max, double initialValue, int steps, boolean showValue, String label) {
        super(x, y);
        this.width = width;
        this.min = min;
        this.max = max;
        this.steps = steps;
        this.showValue = showValue;
        this.label = label;
        this.step = (int)this.valueToStep(initialValue);
        this.stepSize = (double)(width - 8 - 2) / (double)steps;
    }

    private double valueToStep(double value) {
        return (double)this.steps * (value - this.min) / (this.max - this.min);
    }

    private double stepToValue(double step) {
        return step / (double)this.steps * (this.max - this.min) + this.min;
    }

    @Override
    public void render(int offsetX, int offsetY, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int left = offsetX + this.x;
        int top = offsetY + this.y;
        int barStartX = left + 1;
        this.bindComponentsSheet();
        this.func_73729_b(left, top, 0, 70, 1, this.getHeight());
        GL11.glPushMatrix();
        GL11.glTranslated((double)(left + 1), (double)top, (double)0.0);
        GL11.glScaled((double)(this.getWidth() - 2), (double)1.0, (double)1.0);
        this.func_73729_b(0, 0, 1, 70, 1, this.getHeight());
        GL11.glPopMatrix();
        this.func_73729_b(left + this.getWidth() - 1, top, 2, 70, 1, this.getHeight());
        if (!Strings.isNullOrEmpty((String)this.label)) {
            FontRenderer fr = this.parent.getFontRenderer();
            int strWidth = fr.func_78256_a(this.label);
            fr.func_78276_b(this.label, left + this.getWidth() / 2 - strWidth / 2, top + 2, 0x404040);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindComponentsSheet();
        int handleX = (int)Math.floor((double)barStartX + this.stepSize * (double)this.step);
        this.func_73729_b(handleX, top + 1, 3, 70, 9, 10);
        if (this.showValue) {
            double value = this.stepToValue(this.step);
            String label = this.formatValue(value);
            FontRenderer fr = this.parent.getFontRenderer();
            int strWidth = fr.func_78256_a(label);
            fr.func_78276_b(label, handleX + 4 - strWidth / 2, top + 15, 0x404040);
        }
    }

    @Override
    public void mouseDrag(int mouseX, int mouseY, int button, long time) {
        super.mouseDrag(mouseX, mouseY, button, time);
        if (button == 0) {
            int offX = mouseX - 4;
            if (offX < 0) {
                return;
            }
            int newStep = Ints.saturatedCast((long)Math.round((double)offX / this.stepSize));
            int boundedNewStep = Math.max(0, Math.min(this.steps, newStep));
            if (boundedNewStep != this.step) {
                this.step = boundedNewStep;
                double newValue = this.stepToValue(this.step);
                if (this.listener != null) {
                    this.listener.valueChanged(newValue);
                }
            }
        }
    }

    protected String formatValue(double value) {
        return String.format("%.2f", value);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return 12;
    }

    public double getValue() {
        return this.stepToValue(this.step);
    }

    @Override
    public void setValue(Double value) {
        this.step = (int)this.valueToStep(value);
    }

    public void setListener(IValueChangedListener<Double> listener) {
        this.listener = listener;
    }
}

