/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.types.multi;

import com.google.common.collect.Maps;
import info.openmods.calc.types.multi.TypeDomain;
import info.openmods.calc.types.multi.TypedValue;
import java.util.Map;

public class Symbol {
    public final String value;
    private static Map<String, Symbol> pool = Maps.newIdentityHashMap();

    private Symbol(String value) {
        this.value = value;
    }

    public static Symbol get(String value) {
        Symbol result = pool.get(value = value.intern());
        if (result == null) {
            result = new Symbol(value);
            pool.put(value, result);
        }
        return result;
    }

    public static TypedValue get(TypeDomain domain, String value) {
        return domain.create(Symbol.class, Symbol.get(value));
    }

    public String toString() {
        return "#" + this.value;
    }
}

