/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.symbol;

import info.openmods.calc.Frame;
import info.openmods.calc.FrameFactory;
import info.openmods.calc.symbol.FixedCallable;
import info.openmods.calc.utils.Stack;

public abstract class TernaryFunction<E>
extends FixedCallable<E> {
    private TernaryFunction() {
        super(3, 1);
    }

    public static abstract class WithFrame<E>
    extends TernaryFunction<E> {
        protected abstract E call(Frame<E> var1, E var2, E var3, E var4);

        @Override
        public final void call(Frame<E> frame) {
            Frame<E> executionFrame = FrameFactory.newLocalFrameWithSubstack(frame, 3);
            Stack<E> stack = executionFrame.stack();
            E third = stack.pop();
            E second = stack.pop();
            E first = stack.pop();
            E result = this.call(executionFrame, first, second, third);
            stack.checkIsEmpty().push(result);
        }
    }

    public static abstract class Direct<E>
    extends TernaryFunction<E> {
        protected abstract E call(E var1, E var2, E var3);

        @Override
        public final void call(Frame<E> frame) {
            Stack<E> stack = frame.stack();
            E third = stack.pop();
            E second = stack.pop();
            E first = stack.pop();
            E result = this.call(first, second, third);
            stack.push(result);
        }
    }
}

