/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.model.item;

import com.google.common.collect.ImmutableList;
import epicsquid.mysticallib.model.CustomModelItem;
import epicsquid.mysticallib.model.DefaultTransformations;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.ItemLayerModel;
import org.apache.commons.lang3.tuple.Pair;

public class BakedModelItem
implements IBakedModel {
    protected Function<ResourceLocation, TextureAtlasSprite> getter;
    protected VertexFormat format;
    protected ImmutableList.Builder<BakedQuad> quads = ImmutableList.builder();
    protected List<TextureAtlasSprite> layers = new ArrayList<TextureAtlasSprite>();
    protected CustomModelItem model;
    @Nonnull
    protected List<BakedQuad> layerQuads = new ArrayList<BakedQuad>();
    protected TextureAtlasSprite particle = null;

    public BakedModelItem(@Nonnull VertexFormat format, @Nonnull Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, @Nonnull CustomModelItem model) {
        this.getter = bakedTextureGetter;
        this.format = format;
        int i = 0;
        this.model = model;
        while (model.textures.containsKey("layer" + i)) {
            this.layers.add(this.getter.apply((ResourceLocation)model.textures.get("layer" + i)));
            this.layerQuads.addAll((Collection<BakedQuad>)ItemLayerModel.getQuadsForSprite((int)i, (TextureAtlasSprite)this.layers.get(i), (VertexFormat)format, Optional.empty()));
            ++i;
        }
        if (model.textures.containsKey("particle")) {
            this.particle = this.getter.apply((ResourceLocation)model.textures.get("particle"));
        }
    }

    @Nonnull
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        return this.layerQuads;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.particle;
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return new ItemOverrideList(Arrays.asList(new ItemOverride[0]));
    }

    @Nonnull
    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(@Nonnull ItemCameraTransforms.TransformType type) {
        if (this.model.handheld) {
            if (DefaultTransformations.handheldTransforms.containsKey(type)) {
                Matrix4f matrix = DefaultTransformations.handheldTransforms.get(type).getMatrix();
                return Pair.of((Object)this, (Object)matrix);
            }
        } else if (DefaultTransformations.itemTransforms.containsKey(type)) {
            Matrix4f matrix = DefaultTransformations.itemTransforms.get(type).getMatrix();
            return Pair.of((Object)this, (Object)matrix);
        }
        return ForgeHooksClient.handlePerspective((IBakedModel)this, (ItemCameraTransforms.TransformType)type);
    }
}

