/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.model.block;

import epicsquid.mysticallib.model.CustomModelBase;
import epicsquid.mysticallib.model.ModelUtil;
import epicsquid.mysticallib.model.block.BakedModelBlock;
import epicsquid.mysticallib.model.parts.Cube;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockWall;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.model.IModelState;

public class BakedModelWall
extends BakedModelBlock {
    private Cube post;
    private Cube north;
    private Cube south;
    private Cube west;
    private Cube east;

    public BakedModelWall(@Nonnull IModelState state, @Nonnull VertexFormat format, @Nonnull Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, @Nonnull CustomModelBase model) {
        super(format, bakedTextureGetter, model);
        TextureAtlasSprite[] texes = new TextureAtlasSprite[]{this.texwest, this.texeast, this.texdown, this.texup, this.texnorth, this.texsouth};
        this.post = ModelUtil.makeCube(format, 0.25, 0.0, 0.25, 0.5, 1.0, 0.5, null, texes, -1);
        this.north = ModelUtil.makeCube(format, 0.3125, 0.0, 0.0, 0.375, 0.875, 0.5, null, texes, -1);
        this.south = ModelUtil.makeCube(format, 0.3125, 0.0, 0.5, 0.375, 0.875, 0.5, null, texes, -1);
        this.west = ModelUtil.makeCube(format, 0.0, 0.0, 0.3125, 0.5, 0.875, 0.375, null, texes, -1);
        this.east = ModelUtil.makeCube(format, 0.5, 0.0, 0.3125, 0.5, 0.875, 0.375, null, texes, -1);
    }

    @Override
    @Nonnull
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        this.getFaceQuads(quads, side, state);
        return quads;
    }

    private void getFaceQuads(@Nonnull List<BakedQuad> quads, @Nullable EnumFacing side, @Nullable IBlockState state) {
        if (state == null) {
            this.post.addToList(quads, side);
            this.west.addToList(quads, side);
            this.east.addToList(quads, side);
        } else {
            boolean up = (Boolean)state.func_177229_b((IProperty)BlockWall.field_176256_a);
            boolean cnorth = (Boolean)state.func_177229_b((IProperty)BlockWall.field_176254_b);
            boolean csouth = (Boolean)state.func_177229_b((IProperty)BlockWall.field_176258_N);
            boolean cwest = (Boolean)state.func_177229_b((IProperty)BlockWall.field_176259_O);
            boolean ceast = (Boolean)state.func_177229_b((IProperty)BlockWall.field_176257_M);
            if (up) {
                this.post.addToList(quads, side);
            }
            if (cnorth) {
                this.north.addToList(quads, side);
            }
            if (csouth) {
                this.south.addToList(quads, side);
            }
            if (cwest) {
                this.west.addToList(quads, side);
            }
            if (ceast) {
                this.east.addToList(quads, side);
            }
        }
    }
}

