/*
 * Decompiled with CFR 0.152.
 */
package tk.zeitheron.solarflux.shaded.hammerlib.cfg;

public class ReaderHelper {
    String line;
    int pos;

    public int getPos() {
        return this.pos;
    }

    public ReaderHelper(String line) {
        this.line = line;
    }

    public int push() {
        return this.pos;
    }

    public void pop(int marker) {
        this.pos = marker;
    }

    public char eat() {
        return this.eat(false);
    }

    public String currentLine() {
        int i = this.line.substring(0, this.pos).lastIndexOf("\n");
        return this.line.substring(i + 1, this.pos);
    }

    public char eat(boolean ignoreIndents) {
        if (ignoreIndents) {
            while (this.eat(' ', false) || this.eat('\t', false) || this.eat('\n', false) || this.eat('\r', false)) {
            }
        }
        if (this.pos >= this.line.length()) {
            return '\uffff';
        }
        ++this.pos;
        return this.line.charAt(this.pos - 1);
    }

    public boolean eat(String s, boolean ignoreIndents) {
        int origin = this.push();
        for (char c : s.toCharArray()) {
            if (this.eat(c, ignoreIndents)) continue;
            this.pop(origin);
            return false;
        }
        return true;
    }

    public boolean eat(char c, boolean ignoreIndents) {
        if (this.pos >= this.line.length()) {
            return false;
        }
        if (this.line.charAt(this.pos) == c) {
            ++this.pos;
            return true;
        }
        if (ignoreIndents) {
            while (this.eat(' ', false) || this.eat('\t', false) || this.eat('\n', false) || this.eat('\r', false)) {
            }
            return this.eat(c, false);
        }
        return false;
    }

    public String until(char c, boolean eat) {
        int pos = this.push();
        StringBuilder sb = new StringBuilder();
        while (pos < this.line.length()) {
            char r = this.eat();
            if (r != '\uffff') {
                if (r == c) break;
                sb.append(r);
                continue;
            }
            if (!eat) {
                this.pop(pos);
            }
            return null;
        }
        if (!eat) {
            this.pop(pos);
        }
        return sb.toString();
    }

    public String getRest() {
        return this.line.substring(this.pos);
    }
}

