/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing;

import betterquesting.api.enums.EnumQuestVisibility;
import betterquesting.api.properties.IPropertyType;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api.questing.IQuestLineEntry;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.storage.SimpleDatabase;
import betterquesting.questing.QuestLineEntry;
import betterquesting.storage.PropertyContainer;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class QuestLine
extends SimpleDatabase<IQuestLineEntry>
implements IQuestLine {
    private PropertyContainer info = new PropertyContainer();

    public QuestLine() {
        this.setupProps();
    }

    private void setupProps() {
        this.setupValue(NativeProps.NAME, "New Quest Line");
        this.setupValue(NativeProps.DESC, "No Description");
        this.setupValue(NativeProps.ICON, new BigItemStack(Items.field_151122_aG));
        this.setupValue(NativeProps.VISIBILITY, EnumQuestVisibility.NORMAL);
        this.setupValue(NativeProps.BG_IMAGE);
        this.setupValue(NativeProps.BG_SIZE);
    }

    private <T> void setupValue(IPropertyType<T> prop) {
        this.setupValue(prop, prop.getDefault());
    }

    private <T> void setupValue(IPropertyType<T> prop, T def) {
        this.info.setProperty(prop, this.info.getProperty(prop, def));
    }

    @Override
    public IQuestLineEntry createNew(int id) {
        QuestLineEntry qle = new QuestLineEntry(0, 0, 24, 24);
        this.add(id, qle);
        return qle;
    }

    @Override
    public String getUnlocalisedName() {
        String def = "New Quest Line";
        if (!this.info.hasProperty(NativeProps.NAME)) {
            this.info.setProperty(NativeProps.NAME, def);
            return def;
        }
        return this.info.getProperty(NativeProps.NAME, def);
    }

    @Override
    public String getUnlocalisedDescription() {
        String def = "No Description";
        if (!this.info.hasProperty(NativeProps.DESC)) {
            this.info.setProperty(NativeProps.DESC, def);
            return def;
        }
        return this.info.getProperty(NativeProps.DESC, def);
    }

    @Override
    public DBEntry<IQuestLineEntry> getEntryAt(int x, int y) {
        for (DBEntry<IQuestLineEntry> dBEntry : this.getEntries()) {
            int i1 = ((IQuestLineEntry)dBEntry.getValue()).getPosX();
            int j1 = ((IQuestLineEntry)dBEntry.getValue()).getPosY();
            int i2 = i1 + ((IQuestLineEntry)dBEntry.getValue()).getSizeX();
            int j2 = j1 + ((IQuestLineEntry)dBEntry.getValue()).getSizeY();
            if (x < i1 || x >= i2 || y < j1 || y >= j2) continue;
            return dBEntry;
        }
        return null;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound json, @Nullable List<Integer> subset) {
        json.func_74782_a("properties", (NBTBase)this.info.writeToNBT(new NBTTagCompound()));
        NBTTagList jArr = new NBTTagList();
        for (DBEntry entry : this.getEntries()) {
            NBTTagCompound qle = ((IQuestLineEntry)entry.getValue()).writeToNBT(new NBTTagCompound());
            qle.func_74768_a("id", entry.getID());
            jArr.func_74742_a((NBTBase)qle);
        }
        json.func_74782_a("quests", (NBTBase)jArr);
        return json;
    }

    @Override
    public void readFromNBT(NBTTagCompound json, boolean merge) {
        this.info.readFromNBT(json.func_74775_l("properties"));
        this.reset();
        NBTTagList qList = json.func_150295_c("quests", 10);
        for (int i = 0; i < qList.func_74745_c(); ++i) {
            int id;
            NBTTagCompound qTag = qList.func_150305_b(i);
            int n = id = qTag.func_150297_b("id", 99) ? qTag.func_74762_e("id") : -1;
            if (id < 0) continue;
            this.add(id, new QuestLineEntry(qTag));
        }
        this.setupProps();
    }

    @Override
    public <T> T getProperty(IPropertyType<T> prop) {
        return this.info.getProperty(prop);
    }

    @Override
    public <T> T getProperty(IPropertyType<T> prop, T def) {
        return this.info.getProperty(prop, def);
    }

    @Override
    public boolean hasProperty(IPropertyType<?> prop) {
        return this.info.hasProperty(prop);
    }

    @Override
    public <T> void setProperty(IPropertyType<T> prop, T value) {
        this.info.setProperty(prop, value);
    }

    @Override
    public void removeProperty(IPropertyType<?> prop) {
        this.info.removeProperty(prop);
    }

    @Override
    public void removeAllProps() {
        this.info.removeAllProps();
    }
}

