/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.network;

import betterquesting.api.network.IPacketSender;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api2.utils.BQThreadedIO;
import betterquesting.core.BetterQuesting;
import betterquesting.network.PacketAssembly;
import betterquesting.network.PacketQuesting;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketSender
implements IPacketSender {
    public static final PacketSender INSTANCE = new PacketSender();

    @Override
    public void sendToPlayers(QuestingPacket payload, EntityPlayerMP ... players) {
        payload.getPayload().func_74778_a("ID", payload.getHandler().toString());
        BQThreadedIO.INSTANCE.enqueue(() -> {
            List<NBTTagCompound> fragments = PacketAssembly.INSTANCE.splitPacket(payload.getPayload());
            for (EntityPlayerMP p : players) {
                for (NBTTagCompound tag : fragments) {
                    BetterQuesting.instance.network.sendTo((IMessage)new PacketQuesting(tag), p);
                }
            }
        });
    }

    @Override
    public void sendToAll(QuestingPacket payload) {
        payload.getPayload().func_74778_a("ID", payload.getHandler().toString());
        BQThreadedIO.INSTANCE.enqueue(() -> {
            for (NBTTagCompound p : PacketAssembly.INSTANCE.splitPacket(payload.getPayload())) {
                BetterQuesting.instance.network.sendToAll((IMessage)new PacketQuesting(p));
            }
        });
    }

    @Override
    public void sendToServer(QuestingPacket payload) {
        payload.getPayload().func_74778_a("ID", payload.getHandler().toString());
        BQThreadedIO.INSTANCE.enqueue(() -> {
            for (NBTTagCompound p : PacketAssembly.INSTANCE.splitPacket(payload.getPayload())) {
                BetterQuesting.instance.network.sendToServer((IMessage)new PacketQuesting(p));
            }
        });
    }

    @Override
    public void sendToAround(QuestingPacket payload, NetworkRegistry.TargetPoint point) {
        payload.getPayload().func_74778_a("ID", payload.getHandler().toString());
        BQThreadedIO.INSTANCE.enqueue(() -> {
            for (NBTTagCompound p : PacketAssembly.INSTANCE.splitPacket(payload.getPayload())) {
                BetterQuesting.instance.network.sendToAllAround((IMessage)new PacketQuesting(p), point);
            }
        });
    }

    @Override
    public void sendToDimension(QuestingPacket payload, int dimension) {
        payload.getPayload().func_74778_a("ID", payload.getHandler().toString());
        BQThreadedIO.INSTANCE.enqueue(() -> {
            for (NBTTagCompound p : PacketAssembly.INSTANCE.splitPacket(payload.getPayload())) {
                BetterQuesting.instance.network.sendToDimension((IMessage)new PacketQuesting(p), dimension);
            }
        });
    }
}

