/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.toolbox.tools;

import betterquesting.api.client.toolbox.IToolboxTool;
import betterquesting.api.questing.IQuest;
import betterquesting.api2.client.gui.controls.PanelButtonQuest;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.panels.lists.CanvasQuestLine;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetLine;
import betterquesting.api2.storage.DBEntry;
import betterquesting.client.gui2.editors.designer.PanelToolController;
import betterquesting.network.handlers.NetQuestEdit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;

public class ToolboxToolLink
implements IToolboxTool {
    private CanvasQuestLine gui;
    private final NonNullList<PanelButtonQuest> linking = NonNullList.func_191196_a();
    private final GuiRectangle mouseRect = new GuiRectangle(0, 0, 0, 0);

    @Override
    public void initTool(CanvasQuestLine gui) {
        this.gui = gui;
        this.linking.clear();
    }

    @Override
    public void disableTool() {
        this.linking.clear();
    }

    @Override
    public void refresh(CanvasQuestLine gui) {
        if (this.linking.size() <= 0) {
            return;
        }
        ArrayList<PanelButtonQuest> tmp = new ArrayList<PanelButtonQuest>();
        for (PanelButtonQuest b1 : this.linking) {
            for (PanelButtonQuest b2 : gui.getQuestButtons()) {
                if (((DBEntry)b1.getStoredValue()).getID() != ((DBEntry)b2.getStoredValue()).getID()) continue;
                tmp.add(b2);
            }
        }
        this.linking.clear();
        this.linking.addAll(tmp);
    }

    @Override
    public void drawCanvas(int mx, int my, float partialTick) {
        if (this.linking.size() <= 0) {
            return;
        }
        this.mouseRect.x = mx;
        this.mouseRect.y = my;
        for (PanelButtonQuest btn : this.linking) {
            PresetLine.QUEST_COMPLETE.getLine().drawLine(btn.rect, this.mouseRect, 2, PresetColor.QUEST_LINE_COMPLETE.getColor(), partialTick);
        }
    }

    @Override
    public void drawOverlay(int mx, int my, float partialTick) {
    }

    @Override
    public List<String> getTooltip(int mx, int my) {
        return null;
    }

    @Override
    public boolean onMouseClick(int mx, int my, int click) {
        if (click == 1 && this.linking.size() > 0) {
            this.linking.clear();
            return true;
        }
        if (click != 0 || !this.gui.getTransform().contains(mx, my)) {
            return false;
        }
        if (this.linking.size() <= 0) {
            PanelButtonQuest btn = this.gui.getButtonAt(mx, my);
            if (btn == null) {
                return false;
            }
            if (PanelToolController.selected.size() > 0) {
                if (!PanelToolController.selected.contains((Object)btn)) {
                    return false;
                }
                this.linking.addAll(PanelToolController.selected);
                return true;
            }
            this.linking.add((Object)btn);
            return true;
        }
        PanelButtonQuest b2 = this.gui.getButtonAt(mx, my);
        if (b2 == null) {
            return false;
        }
        this.linking.remove((Object)b2);
        if (this.linking.size() > 0) {
            IQuest q2 = (IQuest)((DBEntry)b2.getStoredValue()).getValue();
            boolean mod2 = false;
            NBTTagList dataList = new NBTTagList();
            for (PanelButtonQuest b1 : this.linking) {
                IQuest q1 = (IQuest)((DBEntry)b1.getStoredValue()).getValue();
                boolean mod1 = false;
                if (!this.containsReq(q2, ((DBEntry)b1.getStoredValue()).getID()) && !this.containsReq(q1, ((DBEntry)b2.getStoredValue()).getID())) {
                    mod2 = this.addReq(q2, ((DBEntry)b1.getStoredValue()).getID()) || mod2;
                } else {
                    mod2 = this.removeReq(q2, ((DBEntry)b1.getStoredValue()).getID()) || mod2;
                    mod1 = this.removeReq(q1, ((DBEntry)b2.getStoredValue()).getID());
                }
                if (!mod1) continue;
                NBTTagCompound entry = new NBTTagCompound();
                entry.func_74768_a("questID", ((DBEntry)b1.getStoredValue()).getID());
                entry.func_74782_a("config", (NBTBase)((IQuest)((DBEntry)b1.getStoredValue()).getValue()).writeToNBT(new NBTTagCompound()));
                dataList.func_74742_a((NBTBase)entry);
            }
            if (mod2) {
                NBTTagCompound entry = new NBTTagCompound();
                entry.func_74768_a("questID", ((DBEntry)b2.getStoredValue()).getID());
                entry.func_74782_a("config", (NBTBase)q2.writeToNBT(new NBTTagCompound()));
                dataList.func_74742_a((NBTBase)entry);
            }
            NBTTagCompound payload = new NBTTagCompound();
            payload.func_74782_a("data", (NBTBase)dataList);
            payload.func_74768_a("action", 0);
            NetQuestEdit.sendEdit(payload);
            this.linking.clear();
            return true;
        }
        return false;
    }

    @Override
    public boolean onMouseRelease(int mx, int my, int click) {
        return false;
    }

    @Override
    public boolean onMouseScroll(int mx, int my, int scroll) {
        return false;
    }

    @Override
    public boolean onKeyPressed(char c, int keyCode) {
        return false;
    }

    @Override
    public boolean clampScrolling() {
        return true;
    }

    @Override
    public void onSelection(NonNullList<PanelButtonQuest> buttons) {
    }

    @Override
    public boolean useSelection() {
        return this.linking.size() <= 0;
    }

    private boolean containsReq(IQuest quest, int id) {
        for (int reqID : quest.getRequirements()) {
            if (id != reqID) continue;
            return true;
        }
        return false;
    }

    private boolean removeReq(IQuest quest, int id) {
        int[] orig = quest.getRequirements();
        if (orig.length <= 0) {
            return false;
        }
        boolean hasRemoved = false;
        int[] rem = new int[orig.length - 1];
        for (int i = 0; i < orig.length; ++i) {
            if (!hasRemoved && orig[i] == id) {
                hasRemoved = true;
                continue;
            }
            if (!hasRemoved && i >= rem.length) break;
            rem[!hasRemoved ? i : i - 1] = orig[i];
        }
        if (hasRemoved) {
            quest.setRequirements(rem);
        }
        return hasRemoved;
    }

    private boolean addReq(IQuest quest, int id) {
        if (this.containsReq(quest, id)) {
            return false;
        }
        int[] orig = quest.getRequirements();
        int[] added = Arrays.copyOf(orig, orig.length + 1);
        added[orig.length] = id;
        quest.setRequirements(added);
        return true;
    }
}

