/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.panels.lists;

import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.enums.EnumQuestState;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api.questing.IQuestLineEntry;
import betterquesting.api2.cache.QuestCache;
import betterquesting.api2.client.gui.controls.PanelButtonQuest;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.content.PanelGeneric;
import betterquesting.api2.client.gui.panels.content.PanelLine;
import betterquesting.api2.client.gui.panels.lists.CanvasScrolling;
import betterquesting.api2.client.gui.resources.colors.IGuiColor;
import betterquesting.api2.client.gui.resources.lines.IGuiLine;
import betterquesting.api2.client.gui.resources.textures.SimpleTexture;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetLine;
import betterquesting.api2.storage.DBEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;

public class CanvasQuestLine
extends CanvasScrolling {
    private final List<PanelButtonQuest> btnList = new ArrayList<PanelButtonQuest>();
    private final int buttonId;
    private IQuestLine lastQL;

    public CanvasQuestLine(IGuiRect rect, int buttonId) {
        super(rect);
        this.setupAdvanceScroll(true, true, 24);
        this.enableBlocking(false);
        this.buttonId = buttonId;
    }

    public Collection<PanelButtonQuest> getQuestButtons() {
        return Collections.unmodifiableCollection(this.btnList);
    }

    public PanelButtonQuest getButtonAt(int mx, int my) {
        float zs = ((Float)this.zoomScale.readValue()).floatValue();
        int tx = this.getTransform().getX();
        int ty = this.getTransform().getY();
        int smx = (int)((float)(mx - tx) / zs) + this.lsx;
        int smy = (int)((float)(my - ty) / zs) + this.lsy;
        for (PanelButtonQuest btn : this.btnList) {
            if (!btn.rect.contains(smx, smy)) continue;
            return btn;
        }
        return null;
    }

    public IQuestLine getQuestLine() {
        return this.lastQL;
    }

    public void refreshQuestLine() {
        this.setQuestLine(this.lastQL);
    }

    public void setQuestLine(IQuestLine line) {
        Object quest;
        this.resetCanvas();
        this.btnList.clear();
        this.lastQL = line;
        if (line == null) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        UUID pid = QuestingAPI.getQuestingUUID((EntityPlayer)player);
        String bgString = line.getProperty(NativeProps.BG_IMAGE);
        if (!StringUtils.func_151246_b((String)bgString)) {
            int bgSize = line.getProperty(NativeProps.BG_SIZE);
            this.addPanel(new PanelGeneric(new GuiRectangle(0, 0, bgSize, bgSize, 1), new SimpleTexture(new ResourceLocation(bgString), new GuiRectangle(0, 0, 256, 256))));
        }
        HashMap<Integer, PanelButtonQuest> questBtns = new HashMap<Integer, PanelButtonQuest>();
        for (DBEntry dBEntry : line.getEntries()) {
            quest = (IQuest)QuestingAPI.getAPI(ApiReference.QUEST_DB).getValue(dBEntry.getID());
            if (!QuestCache.isQuestShown((IQuest)quest, pid, (EntityPlayer)player)) continue;
            GuiRectangle rect = new GuiRectangle(((IQuestLineEntry)dBEntry.getValue()).getPosX(), ((IQuestLineEntry)dBEntry.getValue()).getPosY(), ((IQuestLineEntry)dBEntry.getValue()).getSizeX(), ((IQuestLineEntry)dBEntry.getValue()).getSizeY());
            PanelButtonQuest paBtn = new PanelButtonQuest(rect, this.buttonId, "", new DBEntry<Object>(dBEntry.getID(), quest));
            this.addPanel(paBtn);
            this.btnList.add(paBtn);
            questBtns.put(dBEntry.getID(), paBtn);
        }
        for (Map.Entry entry : questBtns.entrySet()) {
            quest = (DBEntry)((PanelButtonQuest)entry.getValue()).getStoredValue();
            List<DBEntry<IQuest>> reqList = QuestingAPI.getAPI(ApiReference.QUEST_DB).bulkLookup(((IQuest)((DBEntry)quest).getValue()).getRequirements());
            if (reqList.size() <= 0) continue;
            boolean main = ((IQuest)((DBEntry)quest).getValue()).getProperty(NativeProps.MAIN);
            EnumQuestState qState = ((IQuest)((DBEntry)quest).getValue()).getState(pid);
            IGuiLine lineRender = null;
            IGuiColor txLineCol = null;
            switch (qState) {
                case LOCKED: {
                    lineRender = PresetLine.QUEST_LOCKED.getLine();
                    txLineCol = PresetColor.QUEST_LINE_LOCKED.getColor();
                    break;
                }
                case UNLOCKED: {
                    lineRender = PresetLine.QUEST_UNLOCKED.getLine();
                    txLineCol = PresetColor.QUEST_LINE_UNLOCKED.getColor();
                    break;
                }
                case UNCLAIMED: {
                    lineRender = PresetLine.QUEST_PENDING.getLine();
                    txLineCol = PresetColor.QUEST_LINE_PENDING.getColor();
                    break;
                }
                case COMPLETED: {
                    lineRender = PresetLine.QUEST_COMPLETE.getLine();
                    txLineCol = PresetColor.QUEST_LINE_COMPLETE.getColor();
                }
            }
            for (DBEntry<IQuest> req : reqList) {
                PanelButtonQuest parBtn = (PanelButtonQuest)questBtns.get(req.getID());
                if (parBtn == null) continue;
                PanelLine prLine = new PanelLine(parBtn.getTransform(), ((PanelButtonQuest)entry.getValue()).getTransform(), lineRender, main ? 8 : 4, txLineCol, 1);
                this.addPanel(prLine);
            }
        }
        this.fitToWindow();
    }

    public void fitToWindow() {
        boolean flag = false;
        int minX = 0;
        int minY = 0;
        int maxX = 0;
        int maxY = 0;
        for (PanelButtonQuest btn : this.btnList) {
            GuiRectangle rect = btn.rect;
            if (!flag) {
                minX = rect.getX();
                minY = rect.getY();
                maxX = minX + rect.getWidth();
                maxY = minY + rect.getHeight();
                flag = true;
                continue;
            }
            minX = Math.min(minX, rect.getX());
            minY = Math.min(minY, rect.getY());
            maxX = Math.max(maxX, rect.getX() + rect.getWidth());
            maxY = Math.max(maxY, rect.getY() + rect.getHeight());
        }
        this.setZoom(Math.min((float)this.getTransform().getWidth() / (float)((maxX += this.margin) - (minX -= this.margin)), (float)this.getTransform().getHeight() / (float)((maxY += this.margin) - (minY -= this.margin))));
        this.refreshScrollBounds();
        IGuiRect bounds = this.getScrollBounds();
        this.setScrollX(bounds.getX() + bounds.getWidth() / 2);
        this.setScrollY(bounds.getY() + bounds.getHeight() / 2);
        this.updatePanelScroll();
    }
}

