/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.panels.content;

import betterquesting.api.utils.RenderUtils;
import betterquesting.api2.client.gui.controls.IValueIO;
import betterquesting.api2.client.gui.controls.io.ValueFuncIO;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;

public class PanelEntityPreview
implements IGuiPanel {
    private final IGuiRect transform;
    private boolean enabled = true;
    public Entity entity;
    private final IValueIO<Float> basePitch;
    private final IValueIO<Float> baseYaw;
    private IValueIO<Float> pitchDriver;
    private IValueIO<Float> yawDriver;
    private float zDepth = 100.0f;

    public PanelEntityPreview(IGuiRect rect, Entity entity) {
        this.transform = rect;
        this.entity = entity;
        this.basePitch = new ValueFuncIO<Float>(() -> Float.valueOf(15.0f));
        this.pitchDriver = this.basePitch;
        this.baseYaw = new ValueFuncIO<Float>(() -> Float.valueOf(-30.0f));
        this.yawDriver = this.baseYaw;
    }

    public PanelEntityPreview setRotationFixed(float pitch, float yaw) {
        this.pitchDriver = this.basePitch;
        this.yawDriver = this.baseYaw;
        this.basePitch.writeValue(Float.valueOf(pitch));
        this.baseYaw.writeValue(Float.valueOf(yaw));
        return this;
    }

    public PanelEntityPreview setRotationDriven(IValueIO<Float> pitch, IValueIO<Float> yaw) {
        this.pitchDriver = pitch == null ? this.basePitch : pitch;
        this.yawDriver = yaw == null ? this.baseYaw : yaw;
        return this;
    }

    public PanelEntityPreview setDepth(float z) {
        this.zDepth = z;
        return this;
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    @Override
    public void initPanel() {
    }

    @Override
    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public IGuiRect getTransform() {
        return this.transform;
    }

    @Override
    public void drawPanel(int mx, int my, float partialTick) {
        if (this.entity == null) {
            return;
        }
        IGuiRect bounds = this.getTransform();
        GlStateManager.func_179094_E();
        RenderUtils.startScissor(new GuiRectangle(bounds));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int sizeX = bounds.getWidth();
        int sizeY = bounds.getHeight();
        float scale = Math.min((float)sizeY / 2.0f / this.entity.field_70131_O, (float)sizeX / 2.0f / this.entity.field_70130_N);
        RenderUtils.RenderEntity(bounds.getX() + sizeX / 2, bounds.getY() + sizeY / 2 + MathHelper.func_76123_f((float)(this.entity.field_70131_O * scale / 2.0f)), (int)scale, this.yawDriver.readValue().floatValue(), this.pitchDriver.readValue().floatValue(), this.entity);
        RenderUtils.endScissor();
        GlStateManager.func_179121_F();
    }

    @Override
    public boolean onMouseClick(int mx, int my, int click) {
        return false;
    }

    @Override
    public boolean onMouseRelease(int mx, int my, int click) {
        return false;
    }

    @Override
    public boolean onMouseScroll(int mx, int my, int scroll) {
        return false;
    }

    @Override
    public boolean onKeyTyped(char c, int keycode) {
        return false;
    }

    @Override
    public List<String> getTooltip(int mx, int my) {
        return null;
    }
}

