/*
 * Decompiled with CFR 0.152.
 */
package rockhounding.api;

import com.google.common.base.Strings;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import rockhounding.api.IReciperBase;

public class IReciperUtils
extends IReciperBase {
    public static boolean isValidStack(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() != null;
    }

    public static boolean isValidFluid(FluidStack fluid) {
        return fluid != null && fluid.getFluid() != null && fluid.amount > 0;
    }

    public static boolean isValidGas(FluidStack gas) {
        return gas != null && gas.getFluid() != null && gas.getFluid().isGaseous() && gas.amount > 0;
    }

    public static boolean isValidConsumable(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() != null && stack.func_77973_b().func_77645_m();
    }

    public static boolean isNonNegativeFloat(List<Float> array) {
        int emptyness = 0;
        for (Float num : array) {
            if (!(num.floatValue() < 0.0f)) continue;
            ++emptyness;
        }
        return emptyness == 0;
    }

    public static boolean isNonNegativeInteger(List<Integer> array) {
        int emptyness = 0;
        for (Integer num : array) {
            if (num >= 0) continue;
            ++emptyness;
        }
        return emptyness == 0;
    }

    public static boolean isValidStackArray(List<ItemStack> array) {
        return !array.isEmpty() && array.size() > 0 && IReciperUtils.noEmptyStack(array);
    }

    private static boolean noEmptyStack(List<ItemStack> array) {
        int emptyness = 0;
        for (ItemStack stack : array) {
            if (!stack.func_190926_b() && stack.func_77973_b() != null) continue;
            ++emptyness;
        }
        return emptyness == 0;
    }

    public static boolean arraysMatch(int a, int b) {
        return a == b;
    }

    public static boolean isValidString(String stack) {
        return !Strings.isNullOrEmpty((String)stack);
    }

    public static ItemStack oredictStack(String input) {
        NonNullList ores = OreDictionary.getOres((String)input);
        ItemStack entryStack = ItemStack.field_190927_a;
        if (!ores.isEmpty() && ores.size() > 0) {
            entryStack = (ItemStack)ores.get(0);
            entryStack.func_190920_e(1);
        }
        return entryStack;
    }

    public static boolean isValidStringArray(List<String> array) {
        return !array.isEmpty() && array.size() > 0 && IReciperUtils.noEmptyString(array);
    }

    private static boolean noEmptyString(List<String> array) {
        int emptyness = 0;
        for (String string : array) {
            if (!Strings.isNullOrEmpty((String)string)) continue;
            ++emptyness;
        }
        return emptyness == 0;
    }
}

