/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_core.machines.tileentity;

import com.globbypotato.rockhounding_core.machines.tileentity.MachineStackHandler;
import com.globbypotato.rockhounding_core.machines.tileentity.TemplateStackHandler;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityBase;
import com.globbypotato.rockhounding_core.machines.tileentity.WrappedItemHandler;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public abstract class TileEntityInv
extends TileEntityBase
implements ITickable {
    public Random rand = new Random();
    public int INVENTORYSIZE;
    protected MachineStackHandler input;
    protected IItemHandlerModifiable automationInput;
    protected MachineStackHandler output;
    protected IItemHandlerModifiable automationOutput;
    protected MachineStackHandler upgrade;
    protected IItemHandlerModifiable automationUpgrade;
    protected ItemStackHandler template;
    public static final int INPUT_SLOT = 0;
    public static final int CONSUMABLE_SLOT = 2;
    public static final int OUTPUT_SLOT = 0;
    public int cooktime = 0;
    public boolean activation = false;
    public int facing = 0;
    public int recipeIndex = -1;

    public TileEntityInv(int inputSlots, int outputSlots, int templateSlots, int upgradeslots) {
        this.INVENTORYSIZE = inputSlots + outputSlots + templateSlots + upgradeslots;
        this.template = new TemplateStackHandler(templateSlots);
        this.input = new MachineStackHandler(inputSlots, this){

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                return super.insertItem(slot, stack, simulate);
            }
        };
        this.automationInput = new WrappedItemHandler((IItemHandlerModifiable)this.input, WrappedItemHandler.WriteMode.IN_OUT);
        this.output = new MachineStackHandler(outputSlots, this){

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                return stack;
            }

            protected void onContentsChanged(int slot) {
                this.tile.func_70296_d();
            }
        };
        this.automationOutput = new WrappedItemHandler((IItemHandlerModifiable)this.output, WrappedItemHandler.WriteMode.IN_OUT){

            @Override
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                ItemStack stack = this.getStackInSlot(slot);
                if (stack != null) {
                    return super.extractItem(slot, amount, simulate);
                }
                return null;
            }
        };
        this.upgrade = new MachineStackHandler(upgradeslots, this){

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                return super.insertItem(slot, stack, simulate);
            }
        };
        this.automationUpgrade = new WrappedItemHandler((IItemHandlerModifiable)this.upgrade, WrappedItemHandler.WriteMode.IN_OUT);
    }

    public IItemHandler getInput() {
        return this.input;
    }

    public IItemHandler getOutput() {
        return this.output;
    }

    public IItemHandler getTemplate() {
        return this.template;
    }

    public IItemHandler getUpgrade() {
        return this.upgrade;
    }

    public IItemHandler getInventory() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.input, this.output, this.upgrade});
    }

    public IItemHandler getCombinedHandler() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.automationInput, this.automationOutput, this.automationUpgrade});
    }

    public boolean isActive() {
        int power = this.field_145850_b.func_175651_c(this.poweredPosition(), this.poweredFacing());
        if (this.isComparatorSensible() && power > 0 && this.activation) {
            this.activation = false;
        }
        return this.activation || this.isComparatorSensible() && power > 0;
    }

    public int getCooktime() {
        return this.cooktime;
    }

    public int getGUIHeight() {
        return 0;
    }

    public int fuelID() {
        return -1;
    }

    public EnumFacing getFacing() {
        return EnumFacing.func_82600_a((int)this.facing);
    }

    public EnumFacing isFacingAt(int side) {
        return EnumFacing.func_176733_a((double)(this.getFacing().func_185119_l() + (float)side));
    }

    public boolean isCooking() {
        return false;
    }

    public int getRecipeIndex() {
        return this.recipeIndex;
    }

    public boolean isComparatorSensible() {
        return true;
    }

    public EnumFacing poweredFacing() {
        return this.getFacing();
    }

    public BlockPos poweredPosition() {
        return this.field_174879_c.func_177972_a(this.poweredFacing());
    }

    public boolean isPowered() {
        int power = this.field_145850_b.func_175651_c(this.poweredPosition(), this.poweredFacing());
        return power > 0;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.input.deserializeNBT(compound.func_74775_l("input"));
        this.output.deserializeNBT(compound.func_74775_l("output"));
        this.upgrade.deserializeNBT(compound.func_74775_l("upgrade"));
        this.cooktime = compound.func_74762_e("Cooktime");
        this.activation = compound.func_74767_n("Activation");
        this.facing = compound.func_74762_e("Facing");
        this.recipeIndex = compound.func_74762_e("RecipeIndex");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("input", (NBTBase)this.input.serializeNBT());
        compound.func_74782_a("output", (NBTBase)this.output.serializeNBT());
        compound.func_74782_a("upgrade", (NBTBase)this.upgrade.serializeNBT());
        compound.func_74768_a("Cooktime", this.getCooktime());
        compound.func_74757_a("Activation", this.activation);
        compound.func_74768_a("Facing", this.getFacing().ordinal());
        compound.func_74768_a("RecipeIndex", this.getRecipeIndex());
        return compound;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.getCombinedHandler());
        }
        return (T)super.getCapability(capability, facing);
    }

    public void tickOff() {
        if (this.getCooktime() > 0) {
            this.cooktime = 0;
            this.markDirtyClient();
        }
    }
}

