/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_core.machines.tileentity;

import com.globbypotato.rockhounding_core.gas.CapabilityGasHandler;
import com.globbypotato.rockhounding_core.gas.GasHandlerConcatenate;
import com.globbypotato.rockhounding_core.machines.PipelineBase;
import com.globbypotato.rockhounding_core.machines.tileentity.IGasHandlingTile;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityFueledTank;
import com.globbypotato.rockhounding_core.utils.CoreBasics;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public abstract class TileEntityFueledVessel
extends TileEntityFueledTank
implements IGasHandlingTile {
    public FluidTank gasTank = new FluidTank(1000){

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid.isFluidEqual(CoreBasics.gasStack(1000));
        }
    };

    public TileEntityFueledVessel(int inputSlots, int outputSlots, int templateSlots, int upgradeSlots) {
        super(inputSlots, outputSlots, templateSlots, upgradeSlots);
        this.gasTank.setTileEntity((TileEntity)this);
        this.gasTank.setCanDrain(false);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.gasTank.readFromNBT(compound.func_74775_l("GasTank"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTTagCompound lavaTankNBT = new NBTTagCompound();
        this.gasTank.writeToNBT(lavaTankNBT);
        compound.func_74782_a("GasTank", (NBTBase)lavaTankNBT);
        return compound;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityGasHandler.GAS_HANDLER_CAPABILITY && this.isGasHandling(facing)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityGasHandler.GAS_HANDLER_CAPABILITY && this.isGasHandling(facing)) {
            return (T)this.getCombinedGasTank();
        }
        return super.getCapability(capability, facing);
    }

    private boolean isGasHandling(EnumFacing facing) {
        Block front = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(this.getFacing())).func_177230_c();
        Block back = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(this.getFacing().func_176734_d())).func_177230_c();
        return facing == this.getFacing() && front instanceof PipelineBase || facing == this.getFacing().func_176734_d() && back instanceof PipelineBase;
    }

    protected GasHandlerConcatenate getCombinedGasTank() {
        return null;
    }

    public int gasBurntime() {
        return 200;
    }

    public void gasHandler() {
        if (!this.hasFuelBlend() && this.gasTank.getFluidAmount() > 0 && this.getPower() <= this.getPowerMax() - this.gasBurntime()) {
            this.input.drainOrCleanFluid(this.gasTank, 1, false);
            this.powerCount += this.gasBurntime();
            this.markDirtyClient();
        }
    }
}

