/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_core.machines.tileentity;

import com.globbypotato.rockhounding_core.handlers.ModConfig;
import com.globbypotato.rockhounding_core.machines.tileentity.IFuelHandlingTile;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.utils.CoreBasics;
import com.globbypotato.rockhounding_core.utils.CoreUtils;
import com.globbypotato.rockhounding_core.utils.FuelUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public abstract class TileEntityFueledMachine
extends TileEntityInv
implements IFuelHandlingTile {
    public int powerCount = 0;
    public int powerMax = 64000;

    public TileEntityFueledMachine(int inputSlots, int outputSlots, int templateSlots, int upgradeSlots) {
        super(inputSlots, outputSlots, templateSlots, upgradeSlots);
    }

    protected void fuelHandler(ItemStack stack) {
        if (this.fuelID() > -1 && !stack.func_190926_b()) {
            if (!this.hasFuelBlend() && FuelUtils.isItemFuel(stack)) {
                this.burnFuel(stack);
                this.markDirtyClient();
            } else if (this.hasFuelBlend() && ItemStack.func_179545_c((ItemStack)stack, (ItemStack)CoreBasics.fuel_blend)) {
                this.burnBlend(stack);
                this.markDirtyClient();
            }
        }
    }

    public boolean isGatedPowerSource(ItemStack insertingStack) {
        return !this.hasFuelBlend() && FuelUtils.isItemFuel(insertingStack) || this.hasFuelBlend() && CoreUtils.hasBlend(insertingStack);
    }

    protected void burnFuel(ItemStack stack) {
        if (this.fuelID() > -1 && !stack.func_190926_b()) {
            if (this.getPower() <= this.getPowerMax() - FuelUtils.getItemBurnTime(stack)) {
                this.powerCount += FuelUtils.getItemBurnTime(stack);
                if (stack.func_77973_b().hasContainerItem(stack)) {
                    if (stack.func_190916_E() > 1) {
                        ItemStack dropContainer = stack.func_77973_b().getContainerItem(this.input.getStackInSlot(this.fuelID()));
                        BlockPos contPos = this.field_174879_c.func_177972_a(this.getFacing().func_176734_d());
                        EntityItem entityCont = new EntityItem(this.field_145850_b, (double)contPos.func_177958_n(), (double)contPos.func_177956_o(), (double)contPos.func_177952_p(), dropContainer);
                        if (!this.field_145850_b.field_72995_K) {
                            this.field_145850_b.func_72838_d((Entity)entityCont);
                        }
                        stack.func_190918_g(1);
                    } else {
                        this.input.setStackInSlot(this.fuelID(), stack.func_77973_b().getContainerItem(this.input.getStackInSlot(this.fuelID())));
                    }
                } else {
                    stack.func_190918_g(1);
                }
            }
            if (stack.func_190916_E() <= 0) {
                this.input.setStackInSlot(this.fuelID(), ItemStack.field_190927_a);
            }
        }
    }

    public boolean hasFuelBlend() {
        return ModConfig.enableFuelBlend;
    }

    public int getBlend() {
        return ModConfig.fuelBlendPower;
    }

    protected void burnBlend(ItemStack stack) {
        if (this.fuelID() > -1 && !stack.func_190926_b() && this.getPower() <= this.getPowerMax() - this.getBlend()) {
            this.powerCount += this.getBlend();
            stack.func_190918_g(1);
            if (stack.func_190916_E() <= 0) {
                this.input.setStackInSlot(this.fuelID(), ItemStack.field_190927_a);
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.powerCount = compound.func_74762_e("PowerCount");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("PowerCount", this.getPower());
        return compound;
    }

    @Override
    public int getPower() {
        return this.powerCount;
    }

    @Override
    public int getPowerMax() {
        return this.powerMax;
    }
}

