/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_core.machines;

import com.globbypotato.rockhounding_core.gas.CapabilityGasHandler;
import com.globbypotato.rockhounding_core.machines.tileentity.IGasHandlingTile;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.utils.CoreBasics;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PipelineBase
extends Block {
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    public static final AxisAlignedBB PLUG_AABB = new AxisAlignedBB(0.25, 0.25, 0.25, 0.75, 0.75, 0.75);

    public PipelineBase(String modid, String name) {
        super(Material.field_151573_f);
        this.setRegistryName(new ResourceLocation(modid, name));
        this.func_149663_c(this.getRegistryName().toString());
        this.func_149711_c(1.0f);
        this.func_149752_b(1.0f);
        this.setHarvestLevel("pickaxe", 0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return null;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        IBlockState actualstate = state.func_185899_b((IBlockAccess)worldIn, pos);
        PipelineBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)PipelineBase.getHitbox(actualstate));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        IBlockState actualstate = this.func_176221_a(state, source, pos);
        return PipelineBase.getHitbox(actualstate);
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    private static AxisAlignedBB getHitbox(IBlockState actualstate) {
        double xmin = 0.375;
        double xmax = 0.625;
        double zmin = 0.375;
        double zmax = 0.625;
        double ymin = 0.375;
        double ymax = 0.625;
        if (((Boolean)actualstate.func_177229_b((IProperty)DOWN)).booleanValue()) {
            ymin = 0.0;
        }
        if (((Boolean)actualstate.func_177229_b((IProperty)UP)).booleanValue()) {
            ymax = 1.0;
        }
        if (((Boolean)actualstate.func_177229_b((IProperty)NORTH)).booleanValue()) {
            zmin = 0.0;
        }
        if (((Boolean)actualstate.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            zmax = 1.0;
        }
        if (((Boolean)actualstate.func_177229_b((IProperty)WEST)).booleanValue()) {
            xmin = 0.0;
        }
        if (((Boolean)actualstate.func_177229_b((IProperty)EAST)).booleanValue()) {
            xmax = 1.0;
        }
        return new AxisAlignedBB(xmin, ymin, zmin, xmax, ymax, zmax);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos, pos.func_177977_b(), EnumFacing.DOWN))).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos, pos.func_177984_a(), EnumFacing.UP))).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos, pos.func_177978_c(), EnumFacing.NORTH))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos, pos.func_177974_f(), EnumFacing.EAST))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos, pos.func_177968_d(), EnumFacing.SOUTH))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos, pos.func_177976_e(), EnumFacing.WEST)));
    }

    public boolean canConnectTo(IBlockAccess worldIn, BlockPos pos, BlockPos sidePos, EnumFacing facing) {
        return false;
    }

    public boolean hasFluidCapability(IBlockState state, Block block, IBlockAccess worldIn, BlockPos pos) {
        return worldIn.func_175625_s(pos) != null && worldIn.func_175625_s(pos).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
    }

    public boolean hasGasCapability(IBlockState state, Block block, IBlockAccess worldIn, BlockPos pos) {
        return worldIn.func_175625_s(pos) != null && worldIn.func_175625_s(pos).hasCapability(CapabilityGasHandler.GAS_HANDLER_CAPABILITY, null);
    }

    public boolean isOrientedVessel(IBlockAccess worldIn, BlockPos pos, EnumFacing facing) {
        TileEntityInv vessel;
        TileEntity tile = worldIn.func_175625_s(pos);
        return tile != null && (tile instanceof IGasHandlingTile || Loader.isModLoaded((String)CoreBasics.r_flux) && tile instanceof IGasHandlingTile) && (vessel = (TileEntityInv)tile).getFacing() == facing;
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DOWN, UP, NORTH, EAST, WEST, SOUTH});
    }
}

