/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.dump.types;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.List;
import java.util.Map;
import stanhebben.zenscript.dump.types.DumpIJavaMethod;
import stanhebben.zenscript.dump.types.DumpZenType;
import stanhebben.zenscript.type.natives.IJavaMethod;
import stanhebben.zenscript.type.natives.ZenNativeCaster;
import stanhebben.zenscript.type.natives.ZenNativeMember;
import stanhebben.zenscript.type.natives.ZenNativeOperator;

public class DumpZenTypeNative
extends DumpZenType {
    private final Map<String, ZenNativeMember> members;
    private final Map<String, ZenNativeMember> staticMembers;
    private final List<ZenNativeCaster> casters;
    private final List<ZenNativeOperator> trinaryOperators;
    private final List<ZenNativeOperator> binaryOperators;
    private final List<ZenNativeOperator> unaryOperators;

    public DumpZenTypeNative(Class<?> clazz, String zsAliasPath, Map<String, ZenNativeMember> members, Map<String, ZenNativeMember> staticMembers, List<ZenNativeCaster> casters, List<ZenNativeOperator> trinaryOperators, List<ZenNativeOperator> binaryOperators, List<ZenNativeOperator> unaryOperators) {
        super(clazz, zsAliasPath);
        this.members = members;
        this.staticMembers = staticMembers;
        this.casters = casters;
        this.trinaryOperators = trinaryOperators;
        this.binaryOperators = binaryOperators;
        this.unaryOperators = unaryOperators;
    }

    @Override
    public JsonObject serialize(JsonSerializationContext context) {
        JsonArray array;
        JsonObject obj = super.serialize(context);
        JsonObject memberMap = new JsonObject();
        JsonArray castersArray = new JsonArray();
        this.members.forEach((name, zenNativeMember) -> this.zenTypeNativeMemberHelper(memberMap, (String)name, (ZenNativeMember)zenNativeMember, false, context));
        this.staticMembers.forEach((name, zenNativeMember) -> this.zenTypeNativeMemberHelper(memberMap, (String)name, (ZenNativeMember)zenNativeMember, true, context));
        obj.add("members", (JsonElement)memberMap);
        if (!this.casters.isEmpty()) {
            for (ZenNativeCaster caster : this.casters) {
                castersArray.add(caster.asDumpedObject().get(0).serialize(context));
            }
            obj.add("casters", (JsonElement)castersArray);
        }
        if (this.operatorHelper(array = new JsonArray(), this.unaryOperators, context) || this.operatorHelper(array, this.binaryOperators, context) || this.operatorHelper(array, this.trinaryOperators, context)) {
            obj.add("operators", (JsonElement)array);
        }
        return obj;
    }

    private void zenTypeNativeMemberHelper(JsonObject memberMap, String name, ZenNativeMember zenNativeMember, boolean isStatic, JsonSerializationContext context) {
        List<IJavaMethod> methodList;
        JsonObject jsonMember = new JsonObject();
        if (zenNativeMember.getGetter() != null) {
            jsonMember.add("getter", (JsonElement)new DumpIJavaMethod(zenNativeMember.getGetter()).withStaticOverride(isStatic).serialize(context));
        }
        if (zenNativeMember.getSetter() != null) {
            jsonMember.add("setter", (JsonElement)new DumpIJavaMethod(zenNativeMember.getSetter()).withStaticOverride(isStatic).serialize(context));
        }
        if (!(methodList = zenNativeMember.getMethods()).isEmpty()) {
            JsonArray methodArray = new JsonArray();
            for (IJavaMethod iJavaMethod : zenNativeMember.getMethods()) {
                methodArray.add((JsonElement)new DumpIJavaMethod(iJavaMethod).serialize(context));
            }
        }
        memberMap.add(name, (JsonElement)jsonMember);
    }

    private boolean operatorHelper(JsonArray obj, List<ZenNativeOperator> operators, JsonSerializationContext context) {
        if (operators.isEmpty()) {
            return false;
        }
        for (ZenNativeOperator unaryOperator : operators) {
            obj.add(unaryOperator.serialize(context));
        }
        return true;
    }
}

