/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.CrafttweakerImplementationAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.network.NetworkSide;
import crafttweaker.mc1120.MCPlatformFunctions;
import crafttweaker.mc1120.brewing.MCBrewing;
import crafttweaker.mc1120.client.MCClient;
import crafttweaker.mc1120.commands.CTChatCommand;
import crafttweaker.mc1120.events.ActionApplyEvent;
import crafttweaker.mc1120.formatting.MCFormatter;
import crafttweaker.mc1120.furnace.MCFurnaceManager;
import crafttweaker.mc1120.game.MCGame;
import crafttweaker.mc1120.item.MCItemUtils;
import crafttweaker.mc1120.logger.MCLogger;
import crafttweaker.mc1120.mods.MCLoadedMods;
import crafttweaker.mc1120.network.MessageCopyClipboard;
import crafttweaker.mc1120.network.MessageOpenBrowser;
import crafttweaker.mc1120.oredict.MCOreDict;
import crafttweaker.mc1120.preprocessors.ModLoadedPreprocessor;
import crafttweaker.mc1120.preprocessors.ZsLintPreprocessor;
import crafttweaker.mc1120.proxies.CommonProxy;
import crafttweaker.mc1120.recipes.MCRecipeManager;
import crafttweaker.mc1120.server.MCServer;
import crafttweaker.mc1120.util.CraftTweakerPlatformUtils;
import crafttweaker.mc1120.vanilla.MCVanilla;
import crafttweaker.runtime.IScriptProvider;
import crafttweaker.runtime.providers.ScriptProviderCascade;
import crafttweaker.runtime.providers.ScriptProviderDirectory;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.RecipeBookClient;
import net.minecraft.client.util.SearchTree;
import net.minecraft.client.util.SearchTreeManager;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="crafttweaker", version="4.1.20", name="Crafttweaker", acceptedMinecraftVersions="[1.12]", updateJSON="https://updates.blamejared.com/get?n=crafttweaker&gv=1.12.2")
public class CraftTweaker {
    public static final String MODID = "crafttweaker";
    public static final String NAME = "Crafttweaker";
    public static final Logger LOG = LogManager.getLogger((String)"Crafttweaker");
    public static final SimpleNetworkWrapper NETWORK = NetworkRegistry.INSTANCE.newSimpleChannel("crafttweaker");
    public static MinecraftServer server;
    @Mod.Instance(value="crafttweaker")
    public static CraftTweaker INSTANCE;
    @SidedProxy(clientSide="crafttweaker.mc1120.proxies.ClientProxy", serverSide="crafttweaker.mc1120.proxies.CommonProxy")
    public static CommonProxy PROXY;
    private static Set<String> PATRON_LIST;
    public static List<IAction> LATE_ACTIONS;
    public MCRecipeManager recipes;
    private IScriptProvider scriptsGlobal;
    private static boolean alreadyChangedThePlayer;

    @Mod.EventHandler
    public void onConstruction(FMLConstructionEvent event) {
        new Thread(() -> {
            try {
                URL url = new URL("https://blamejared.com/patrons.txt");
                URLConnection urlConnection = url.openConnection();
                urlConnection.setConnectTimeout(15000);
                urlConnection.setReadTimeout(15000);
                urlConnection.setRequestProperty("User-Agent", "CraftTweaker|1.12.2");
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));){
                    PATRON_LIST = reader.lines().filter(s -> !s.isEmpty()).collect(Collectors.toSet());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }).start();
        this.recipes = new MCRecipeManager();
        CrafttweakerImplementationAPI.init(new MCOreDict(), this.recipes, new MCFurnaceManager(), MCGame.INSTANCE, new MCLoadedMods(), new MCFormatter(), new MCVanilla(), new MCItemUtils(), new MCBrewing());
        CrafttweakerImplementationAPI.logger.addLogger(new MCLogger(new File("crafttweaker.log")));
        CrafttweakerImplementationAPI.platform = MCPlatformFunctions.INSTANCE;
        File globalDir = new File("scripts");
        if (!globalDir.exists()) {
            globalDir.mkdirs();
        }
        this.scriptsGlobal = new ScriptProviderDirectory(globalDir);
        CrafttweakerImplementationAPI.setScriptProvider(this.scriptsGlobal);
        if (event.getSide().isServer()) {
            CraftTweakerAPI.tweaker.setNetworkSide(NetworkSide.SIDE_SERVER);
        } else {
            CraftTweakerAPI.tweaker.setNetworkSide(NetworkSide.SIDE_CLIENT);
        }
        CraftTweakerAPI.tweaker.getPreprocessorManager().registerPreprocessorAction("modloaded", ModLoadedPreprocessor::new);
        CraftTweakerAPI.tweaker.getPreprocessorManager().registerPreprocessorAction("zslint", ZsLintPreprocessor::new);
    }

    @Mod.EventHandler
    public void onPreInitialization(FMLPreInitializationEvent ev) {
        PROXY.registerEvents();
        ev.getAsmData().getAll(ZenRegister.class.getCanonicalName()).forEach(clazz -> {
            try {
                Class<?> claz = Class.forName(clazz.getClassName(), false, CraftTweaker.class.getClassLoader());
                if (claz.isAnnotationPresent(ModOnly.class)) {
                    if (Loader.isModLoaded((String)claz.getAnnotation(ModOnly.class).value())) {
                        CraftTweakerAPI.registerClass(claz);
                    }
                } else {
                    CraftTweakerAPI.registerClass(claz);
                }
            }
            catch (ClassNotFoundException e) {
                LOG.catching((Throwable)e);
            }
        });
        if (CraftTweakerPlatformUtils.isClient()) {
            CraftTweakerAPI.client = new MCClient();
        }
        if (!PATRON_LIST.isEmpty()) {
            StringBuilder builder = new StringBuilder("Thank you to the Patreon supporters below and others who make CraftTweaker possible!").append("\n");
            ArrayList<String> temp = new ArrayList<String>(PATRON_LIST);
            Collections.shuffle(temp);
            for (int i = 0; i < Math.min(20, temp.size()); ++i) {
                builder.append((String)temp.get(i)).append("\n");
            }
            builder.append("If you want to support the mod, checkout https://patreon.com/jaredlll08?s=crtmod").append("\n");
            CraftTweakerAPI.getLogger().logInfo(builder.toString());
        }
        ScriptProviderCascade cascaded = new ScriptProviderCascade(this.scriptsGlobal);
        CrafttweakerImplementationAPI.setScriptProvider(cascaded);
        CraftTweakerAPI.tweaker.getOrCreateLoader("preinit").setMainName("preinit");
        CraftTweakerAPI.tweaker.loadScript(false, "preinit");
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent ev) {
        MinecraftForge.EVENT_BUS.post((Event)new ActionApplyEvent.Pre());
        try {
            MCRecipeManager.recipes = ForgeRegistries.RECIPES.getEntries();
            CraftTweakerAPI.apply(MCRecipeManager.actionRemoveRecipesNoIngredients);
            MCRecipeManager.recipesToRemove.forEach(CraftTweakerAPI::apply);
            MCRecipeManager.recipesToAdd.forEach(CraftTweakerAPI::apply);
            MCFurnaceManager.recipesToRemove.forEach(CraftTweakerAPI::apply);
            MCFurnaceManager.recipesToAdd.forEach(CraftTweakerAPI::apply);
            LATE_ACTIONS.forEach(CraftTweakerAPI::apply);
            MCRecipeManager.recipes = ForgeRegistries.RECIPES.getEntries();
            MCRecipeManager.cleanUpRecipeList();
        }
        catch (Exception e) {
            LOG.catching((Throwable)e);
            CraftTweakerAPI.logError("Error while applying actions", e);
        }
        MinecraftForge.EVENT_BUS.post((Event)new ActionApplyEvent.Post());
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void onFMLLoadComplete(FMLLoadCompleteEvent event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (!alreadyChangedThePlayer) {
            alreadyChangedThePlayer = true;
            RecipeBookClient.rebuildTable();
            if (CraftTweakerAPI.ENABLE_SEARCH_TREE_RECALCULATION) {
                minecraft.func_193986_ar();
                ((SearchTree)minecraft.getSearchTreeManager().func_194010_a(SearchTreeManager.field_194011_a)).func_194040_a();
                ((SearchTree)minecraft.getSearchTreeManager().func_194010_a(SearchTreeManager.field_194012_b)).func_194040_a();
            }
            CraftTweakerAPI.logInfo("Fixed the RecipeBook");
        }
    }

    @Mod.EventHandler
    public void onInit(FMLInitializationEvent ev) {
        MCBrewing.fixBrewingRecipes();
        PROXY.registerReloadListener();
    }

    @Mod.EventHandler
    public void onServerAboutToStart(FMLServerAboutToStartEvent ev) {
        server = ev.getServer();
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent ev) {
        server = ev.getServer();
        if (CraftTweakerPlatformUtils.isClient()) {
            CraftTweakerAPI.client = new MCClient();
        }
        ScriptProviderCascade cascaded = new ScriptProviderCascade(this.scriptsGlobal);
        CrafttweakerImplementationAPI.setScriptProvider(cascaded);
        CrafttweakerImplementationAPI.onServerStart(new MCServer(ev.getServer()));
        CTChatCommand.register(ev);
    }

    @Mod.EventHandler
    public void onServerStopped(FMLServerStoppedEvent ev) {
        CrafttweakerImplementationAPI.onServerStop();
        CrafttweakerImplementationAPI.setScriptProvider(this.scriptsGlobal);
        server = null;
    }

    static {
        PATRON_LIST = new HashSet<String>();
        LATE_ACTIONS = new LinkedList<IAction>();
        int ID = 0;
        NETWORK.registerMessage(MessageOpenBrowser.class, MessageOpenBrowser.class, ID++, Side.CLIENT);
        NETWORK.registerMessage(MessageCopyClipboard.class, MessageCopyClipboard.class, ID, Side.CLIENT);
        alreadyChangedThePlayer = false;
    }
}

