/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.api.recipes;

import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.player.IPlayer;
import crafttweaker.api.recipes.CraftingInfo;
import crafttweaker.api.recipes.ICraftingInventory;
import crafttweaker.api.recipes.ICraftingRecipe;
import crafttweaker.api.recipes.IRecipeAction;
import crafttweaker.api.recipes.IRecipeFunction;
import java.util.HashMap;

@Deprecated
public class ShapelessRecipe
implements ICraftingRecipe {
    private final IItemStack output;
    private final IRecipeFunction function;
    private final IRecipeAction action;
    private final IIngredient[] ingredients;
    private final String name;

    public ShapelessRecipe(IItemStack output, IIngredient[] ingredients, IRecipeFunction function, IRecipeAction action) {
        this("shapeless_" + output.getName() + "_" + output.getDamage(), output, ingredients, function, action);
    }

    public ShapelessRecipe(String name, IItemStack output, IIngredient[] ingredients, IRecipeFunction function, IRecipeAction action) {
        this.output = output;
        this.function = function;
        this.ingredients = ingredients;
        this.action = action;
        this.name = name;
    }

    private static RecipeMatching matchShapeless(IIngredient[] recipe, ICraftingInventory ingredients) {
        int numItems = 0;
        for (int i = 0; i < ingredients.getSize(); ++i) {
            if (ingredients.getStack(i) == null) continue;
            ++numItems;
        }
        if (numItems != recipe.length) {
            return null;
        }
        IItemStack[] matched = new IItemStack[recipe.length];
        int[] indices = new int[recipe.length];
        block1: for (int i = 0; i < ingredients.getSize(); ++i) {
            IItemStack ingredient = ingredients.getStack(i);
            if (ingredient == null) continue;
            for (int j = 0; j < recipe.length; ++j) {
                if (matched[j] != null || !recipe[j].matches(ingredient)) continue;
                matched[j] = ingredient;
                indices[j] = i;
                continue block1;
            }
            return null;
        }
        return new RecipeMatching(matched, indices);
    }

    public int getSize() {
        return this.ingredients.length;
    }

    public IIngredient[] getIngredients() {
        return this.ingredients;
    }

    @Override
    public IItemStack getOutput() {
        return this.output;
    }

    @Override
    public boolean matches(ICraftingInventory inventory) {
        return ShapelessRecipe.matchShapeless(this.ingredients, inventory) != null;
    }

    @Override
    public IItemStack getCraftingResult(ICraftingInventory inventory) {
        RecipeMatching matching = ShapelessRecipe.matchShapeless(this.ingredients, inventory);
        IItemStack actualOutput = this.output;
        if (this.function != null) {
            HashMap<String, IItemStack> map = new HashMap<String, IItemStack>();
            for (int i = 0; i < this.ingredients.length; ++i) {
                if (this.ingredients[i].getMark() == null) continue;
                map.put(this.ingredients[i].getMark(), matching.inputs[i]);
            }
            actualOutput = this.function.process(actualOutput, map, new CraftingInfo(inventory, null));
        }
        if (actualOutput == null) {
            return null;
        }
        return actualOutput;
    }

    @Override
    public void applyTransformers(ICraftingInventory inventory, IPlayer byPlayer) {
        RecipeMatching matching = ShapelessRecipe.matchShapeless(this.ingredients, inventory);
        for (int i = 0; i < this.ingredients.length; ++i) {
            IIngredient ingredient = this.ingredients[i];
            IItemStack transformed = ingredient.applyNewTransform(matching.inputs[i]);
            if (transformed == matching.inputs[i]) continue;
            inventory.setStack(matching.indices[i], transformed);
        }
    }

    @Override
    public IIngredient[] getIngredients1D() {
        return new IIngredient[0];
    }

    @Override
    public IIngredient[][] getIngredients2D() {
        return new IIngredient[0][];
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isShaped() {
        return false;
    }

    @Override
    public String toCommandString() {
        StringBuilder result = new StringBuilder();
        result.append("recipes.addShapeless(");
        if (this.output != null) {
            result.append(this.output);
        } else {
            result.append("null");
        }
        result.append(", [");
        for (int i = 0; i < this.ingredients.length; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(this.ingredients[i]);
        }
        result.append("]);");
        return result.toString();
    }

    @Override
    public boolean hasTransformers() {
        for (IIngredient ingredient : this.ingredients) {
            if (!ingredient.hasNewTransformers()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasRecipeAction() {
        return false;
    }

    @Override
    public boolean hasRecipeFunction() {
        return false;
    }

    public IRecipeAction getAction() {
        return this.action;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFullResourceName() {
        return null;
    }

    @Override
    public String getResourceDomain() {
        return null;
    }

    private static class RecipeMatching {
        public final IItemStack[] inputs;
        public final int[] indices;

        public RecipeMatching(IItemStack[] inputs, int[] indices) {
            this.inputs = inputs;
            this.indices = indices;
        }
    }
}

