/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FilenameUtils;
import vazkii.patchouli.client.book.BookContents;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookFolderLoader;

public class ExternalBookContents
extends BookContents {
    public ExternalBookContents(Book book) {
        super(book);
    }

    @Override
    protected void findFiles(String dir, List<ResourceLocation> list) {
        File searchDir;
        File root = new File(BookFolderLoader.loadDir, this.book.resourceLoc.func_110623_a());
        File enUs = new File(root, "en_us");
        if (enUs.exists() && (searchDir = new File(enUs, dir)).exists()) {
            this.crawl(searchDir, searchDir, list);
        }
    }

    private void crawl(File realRoot, File root, List<ResourceLocation> list) {
        File[] files;
        for (File f : files = root.listFiles()) {
            if (f.isDirectory()) {
                this.crawl(realRoot, f, list);
                continue;
            }
            if (!f.getName().endsWith(".json")) continue;
            list.add(this.relativize(realRoot, f));
        }
    }

    private ResourceLocation relativize(File root, File f) {
        String rootPath = root.getAbsolutePath();
        String filePath = f.getAbsolutePath().substring(rootPath.length() + 1);
        String cleanPath = FilenameUtils.removeExtension((String)FilenameUtils.separatorsToUnix((String)filePath));
        return new ResourceLocation("patchouli", cleanPath);
    }

    @Override
    protected InputStream loadJson(ResourceLocation resloc, ResourceLocation fallback) {
        String realPath = resloc.func_110623_a().substring(BookFolderLoader.loadDir.getName().length());
        File targetFile = new File(BookFolderLoader.loadDir, realPath);
        if (targetFile.exists()) {
            try {
                FileInputStream stream = new FileInputStream(targetFile);
                return stream;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (fallback != null) {
            new RuntimeException("Patchouli failed to load " + resloc + ". Switching to fallback.").printStackTrace();
            return this.loadJson(fallback, null);
        }
        return null;
    }
}

