/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.ironchest.common.blocks.shulker;

import cpw.mods.ironchest.common.gui.shulker.slot.ValidatingShulkerBoxSlot;
import cpw.mods.ironchest.common.tileentity.shulker.TileEntityCopperShulkerBox;
import cpw.mods.ironchest.common.tileentity.shulker.TileEntityCrystalShulkerBox;
import cpw.mods.ironchest.common.tileentity.shulker.TileEntityDiamondShulkerBox;
import cpw.mods.ironchest.common.tileentity.shulker.TileEntityGoldShulkerBox;
import cpw.mods.ironchest.common.tileentity.shulker.TileEntityIronShulkerBox;
import cpw.mods.ironchest.common.tileentity.shulker.TileEntityObsidianShulkerBox;
import cpw.mods.ironchest.common.tileentity.shulker.TileEntitySilverShulkerBox;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.IStringSerializable;

public enum IronShulkerBoxType implements IStringSerializable
{
    IRON(54, 9, true, "_iron.png", TileEntityIronShulkerBox.class, 184, 202),
    GOLD(81, 9, true, "_gold.png", TileEntityGoldShulkerBox.class, 184, 256),
    DIAMOND(108, 12, true, "_diamond.png", TileEntityDiamondShulkerBox.class, 184, 256),
    COPPER(45, 9, false, "_copper.png", TileEntityCopperShulkerBox.class, 184, 184),
    SILVER(72, 9, false, "_silver.png", TileEntitySilverShulkerBox.class, 184, 238),
    CRYSTAL(108, 12, true, "_crystal.png", TileEntityCrystalShulkerBox.class, 238, 256),
    OBSIDIAN(108, 12, false, "_obsidian.png", TileEntityObsidianShulkerBox.class, 238, 256),
    VANILLA(0, 0, false, "", null, 0, 0);

    public static final IronShulkerBoxType[] VALUES;
    public final String name = this.name().toLowerCase();
    public final int size;
    public final int rowLength;
    public final boolean tieredShulkerBox;
    public final String modelTexture;
    public final Class<? extends TileEntityIronShulkerBox> clazz;
    public final int xSize;
    public final int ySize;
    private String breakTexture;

    private IronShulkerBoxType(int size, int rowLength, boolean tieredShulkerBox, String modelTexture, Class<? extends TileEntityIronShulkerBox> clazz, int xSize, int ySize) {
        this.size = size;
        this.rowLength = rowLength;
        this.tieredShulkerBox = tieredShulkerBox;
        this.modelTexture = modelTexture;
        this.clazz = clazz;
        this.xSize = xSize;
        this.ySize = ySize;
    }

    public String func_176610_l() {
        return this.name;
    }

    public String getBreakTexture() {
        if (this.breakTexture == null) {
            switch (this) {
                case OBSIDIAN: {
                    this.breakTexture = "minecraft:blocks/obsidian";
                    break;
                }
                case VANILLA: {
                    this.breakTexture = "minecraft:blocks/planks_oak";
                    break;
                }
                default: {
                    this.breakTexture = "ironchest:blocks/" + this.func_176610_l() + "break";
                }
            }
        }
        return this.breakTexture;
    }

    public int getRowCount() {
        return this.size / this.rowLength;
    }

    public boolean isTransparent() {
        return this == CRYSTAL;
    }

    public boolean isValidForCreativeMode() {
        return this != VANILLA;
    }

    public boolean isExplosionResistant() {
        return this == OBSIDIAN;
    }

    public Slot makeSlot(IInventory chestInventory, int index, int x, int y) {
        return new ValidatingShulkerBoxSlot(chestInventory, index, x, y);
    }

    public TileEntityIronShulkerBox makeEntity(EnumDyeColor colorIn) {
        switch (this) {
            case IRON: {
                return new TileEntityIronShulkerBox(colorIn);
            }
            case GOLD: {
                return new TileEntityGoldShulkerBox(colorIn);
            }
            case DIAMOND: {
                return new TileEntityDiamondShulkerBox(colorIn);
            }
            case COPPER: {
                return new TileEntityCopperShulkerBox(colorIn);
            }
            case SILVER: {
                return new TileEntitySilverShulkerBox(colorIn);
            }
            case CRYSTAL: {
                return new TileEntityCrystalShulkerBox(colorIn);
            }
            case OBSIDIAN: {
                return new TileEntityObsidianShulkerBox(colorIn);
            }
        }
        return null;
    }

    static {
        VALUES = IronShulkerBoxType.values();
    }
}

