/*
 * Decompiled with CFR 0.152.
 */
package panszelescik.morelibs.client;

import net.minecraft.block.Block;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import panszelescik.morelibs.api.IModelRegister;
import panszelescik.morelibs.api.ZoomHelper;
import panszelescik.morelibs.client.ClientHelper;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="morelibs")
public final class ClientEventHandler {
    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent e) {
        for (Item item : Item.field_150901_e) {
            if (!(item instanceof IModelRegister)) continue;
            ((IModelRegister)item).registerModel();
        }
        for (Block block : Block.field_149771_c) {
            if (!(block instanceof IModelRegister)) continue;
            ((IModelRegister)block).registerModel();
        }
    }

    @SubscribeEvent
    public static void onRenderOverlayPre(RenderGameOverlayEvent.Pre event) {
        if (ZoomHelper.isZooming && event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            event.setCanceled(true);
            if (ZoomHelper.isZooming && ClientHelper.mc().field_71474_y.field_74320_O == 0) {
                ZoomHelper.IZoomable tool;
                float[] steps;
                ClientHelper.bindTexture("morelibs:textures/gui/scope.png");
                int width = event.getResolution().func_78326_a();
                int height = event.getResolution().func_78328_b();
                int resMin = Math.min(width, height);
                float offsetX = (float)(width - resMin) / 2.0f;
                float offsetY = (float)(height - resMin) / 2.0f;
                if (resMin == width) {
                    ClientHelper.drawColouredRect(0, 0, width, (int)offsetY + 1, -16777216);
                    ClientHelper.drawColouredRect(0, (int)offsetY + resMin, width, (int)offsetY + 1, -16777216);
                } else {
                    ClientHelper.drawColouredRect(0, 0, (int)offsetX + 1, height, -16777216);
                    ClientHelper.drawColouredRect((int)offsetX + resMin, 0, (int)offsetX + 1, height, -16777216);
                }
                GlStateManager.func_179147_l();
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                GlStateManager.func_179109_b((float)offsetX, (float)offsetY, (float)0.0f);
                ClientHelper.drawTexturedRect(0.0f, 0.0f, (float)resMin, (float)resMin, 0.0, 1.0, 0.0, 1.0);
                ClientHelper.bindTexture("morelibs:textures/gui/hud_elements.png");
                ClientHelper.drawTexturedRect(0.8515625f * (float)resMin, 0.25f * (float)resMin, 0.09375f * (float)resMin, 0.5f * (float)resMin, 0.25, 0.34375, 0.375, 0.875);
                ItemStack equipped = ClientHelper.getZoomable(ClientHelper.mc().field_71439_g);
                if (equipped != ItemStack.field_190927_a && (steps = (tool = (ZoomHelper.IZoomable)equipped.func_77973_b()).getZoomSteps(equipped, (EntityPlayer)ClientHelper.mc().field_71439_g)) != null && steps.length > 1) {
                    int curStep = -1;
                    float dist = 0.0f;
                    float totalOffset = 0.0f;
                    float stepLength = 118.0f / (float)steps.length;
                    float stepOffset = (stepLength - 7.0f) / 2.0f;
                    GlStateManager.func_179109_b((float)(0.87109375f * (float)resMin), (float)(0.25f * (float)resMin), (float)0.0f);
                    GlStateManager.func_179109_b((float)0.0f, (float)((5.0f + stepOffset) / 256.0f * (float)resMin), (float)0.0f);
                    for (int i = 0; i < steps.length; ++i) {
                        ClientHelper.drawTexturedRect(0.0f, 0.0f, 0.03125f * (float)resMin, 0.02734375f * (float)resMin, 0.34375, 0.375, 0.375, 0.40234375);
                        GlStateManager.func_179109_b((float)0.0f, (float)(stepLength / 256.0f * (float)resMin), (float)0.0f);
                        totalOffset += stepLength;
                        if (curStep != -1 && !(Math.abs(steps[i] - ZoomHelper.fovZoom) < dist)) continue;
                        curStep = i;
                        dist = Math.abs(steps[i] - ZoomHelper.fovZoom);
                    }
                    GlStateManager.func_179109_b((float)0.0f, (float)(-totalOffset / 256.0f * (float)resMin), (float)0.0f);
                    if (curStep >= 0 && curStep < steps.length) {
                        GlStateManager.func_179109_b((float)(0.0234375f * (float)resMin), (float)((float)curStep * stepLength / 256.0f * (float)resMin), (float)0.0f);
                        ClientHelper.drawTexturedRect(0.0f, 0.0f, 0.03125f * (float)resMin, 0.02734375f * (float)resMin, 0.34375, 0.3828125, 0.40234375, 0.4296875);
                        ClientHelper.font().func_78276_b(1.0f / steps[curStep] + "x", (int)(0.0625f * (float)resMin), 0, 0xFFFFFF);
                        GlStateManager.func_179109_b((float)(-0.0234375f * (float)resMin), (float)((float)(-curStep) * stepLength / 256.0f * (float)resMin), (float)0.0f);
                    }
                    GlStateManager.func_179109_b((float)0.0f, (float)(-((5.0f + stepOffset) / 256.0f * (float)resMin)), (float)0.0f);
                    GlStateManager.func_179109_b((float)(-0.87109375f * (float)resMin), (float)(-0.25f * (float)resMin), (float)0.0f);
                }
                GlStateManager.func_179109_b((float)(-offsetX), (float)(-offsetY), (float)0.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onFOVUpdate(FOVUpdateEvent event) {
        EntityPlayerSP player = ClientHelper.mc().field_71439_g;
        ItemStack equipped = ClientHelper.getZoomable(ClientHelper.mc().field_71439_g);
        if (equipped != ItemStack.field_190927_a) {
            if (player.func_70093_af() && player.field_70122_E && ClientHelper.mc().field_71474_y.field_74320_O == 0) {
                ZoomHelper.IZoomable tool = (ZoomHelper.IZoomable)equipped.func_77973_b();
                if (tool.canZoom(equipped, (EntityPlayer)player)) {
                    if (!ZoomHelper.isZooming) {
                        float[] steps = tool.getZoomSteps(equipped, (EntityPlayer)player);
                        if (steps != null && steps.length > 0) {
                            int curStep = -1;
                            float dist = 0.0f;
                            for (int i = 0; i < steps.length; ++i) {
                                if (curStep != -1 && !(Math.abs(steps[i] - ZoomHelper.fovZoom) < dist)) continue;
                                curStep = i;
                                dist = Math.abs(steps[i] - ZoomHelper.fovZoom);
                            }
                            ZoomHelper.fovZoom = curStep != -1 ? steps[curStep] : event.getFov();
                        }
                        ZoomHelper.isZooming = true;
                    }
                    event.setNewfov(ZoomHelper.fovZoom);
                } else if (ZoomHelper.isZooming) {
                    ZoomHelper.isZooming = false;
                }
            } else if (ZoomHelper.isZooming) {
                ZoomHelper.isZooming = false;
            }
        } else if (ZoomHelper.isZooming) {
            ZoomHelper.isZooming = false;
        }
    }

    @SubscribeEvent
    public static void onMouseEvent(MouseEvent event) {
        float[] steps;
        ZoomHelper.IZoomable tool;
        ItemStack equipped;
        EntityPlayerSP player;
        if (event.getDwheel() != 0 && ClientHelper.mc().field_71474_y.field_74320_O == 0 && (player = ClientHelper.mc().field_71439_g).func_70093_af() && (equipped = ClientHelper.getZoomable(ClientHelper.mc().field_71439_g)) != ItemStack.field_190927_a && (tool = (ZoomHelper.IZoomable)equipped.func_77973_b()).canZoom(equipped, (EntityPlayer)player) && (steps = tool.getZoomSteps(equipped, (EntityPlayer)player)) != null && steps.length > 0) {
            int curStep = -1;
            float dist = 0.0f;
            for (int i = 0; i < steps.length; ++i) {
                if (curStep != -1 && !(Math.abs(steps[i] - ZoomHelper.fovZoom) < dist)) continue;
                curStep = i;
                dist = Math.abs(steps[i] - ZoomHelper.fovZoom);
            }
            if (curStep != -1) {
                int newStep = curStep + (event.getDwheel() > 0 ? -1 : 1);
                if (newStep >= 0 && newStep < steps.length) {
                    ZoomHelper.fovZoom = steps[newStep];
                }
                event.setCanceled(true);
            }
        }
    }
}

