/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.network;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import vazkii.botania.common.network.PacketBotaniaEffect;
import vazkii.botania.common.network.PacketDodge;
import vazkii.botania.common.network.PacketItemAge;
import vazkii.botania.common.network.PacketJump;
import vazkii.botania.common.network.PacketLeftClick;

public final class PacketHandler {
    private static final SimpleNetworkWrapper HANDLER = new SimpleNetworkWrapper("botania");

    public static void init() {
        int id = 0;
        HANDLER.registerMessage(PacketBotaniaEffect.Handler.class, PacketBotaniaEffect.class, id++, Side.CLIENT);
        HANDLER.registerMessage(PacketLeftClick.Handler.class, PacketLeftClick.class, id++, Side.SERVER);
        HANDLER.registerMessage(PacketDodge.Handler.class, PacketDodge.class, id++, Side.SERVER);
        HANDLER.registerMessage(PacketJump.Handler.class, PacketJump.class, id++, Side.SERVER);
        HANDLER.registerMessage(PacketItemAge.Handler.class, PacketItemAge.class, id++, Side.CLIENT);
    }

    public static void sendToNearby(World world, BlockPos pos, IMessage toSend) {
        if (world instanceof WorldServer) {
            WorldServer ws = (WorldServer)world;
            for (EntityPlayer player : ws.field_73010_i) {
                EntityPlayerMP playerMP = (EntityPlayerMP)player;
                if (!(playerMP.func_174818_b(pos) < 4096.0) || !ws.func_184164_w().func_72694_a(playerMP, pos.func_177958_n() >> 4, pos.func_177952_p() >> 4)) continue;
                HANDLER.sendTo(toSend, playerMP);
            }
        }
    }

    public static void sendToNearby(World world, Entity e, IMessage toSend) {
        PacketHandler.sendToNearby(world, new BlockPos(e), toSend);
    }

    public static void sendTo(EntityPlayerMP playerMP, IMessage toSend) {
        HANDLER.sendTo(toSend, playerMP);
    }

    public static void sendToServer(IMessage msg) {
        HANDLER.sendToServer(msg);
    }

    private PacketHandler() {
    }
}

