/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import vazkii.botania.api.item.IBlockProvider;
import vazkii.botania.client.core.handler.ItemsRemainingRenderHandler;
import vazkii.botania.client.core.handler.ModelHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.ItemMod;

public class ItemBlackHoleTalisman
extends ItemMod
implements IBlockProvider {
    private static final String TAG_BLOCK_NAME = "blockName";
    private static final String TAG_BLOCK_META = "blockMeta";
    private static final String TAG_BLOCK_COUNT = "blockCount";

    public ItemBlackHoleTalisman() {
        super("blackHoleTalisman");
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (ItemBlackHoleTalisman.getBlock(stack) != null && player.func_70093_af()) {
            int dmg = stack.func_77952_i();
            stack.func_77964_b(~dmg & 1);
            player.func_184185_a(SoundEvents.field_187604_bf, 0.3f, 0.1f);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        IBlockState state = world.func_180495_p(pos);
        ItemStack stack = player.func_184586_b(hand);
        if (Item.func_150898_a((Block)state.func_177230_c()) != Items.field_190931_a && this.setBlock(stack, state.func_177230_c(), state.func_177230_c().func_176201_c(state))) {
            return EnumActionResult.SUCCESS;
        }
        Block bBlock = ItemBlackHoleTalisman.getBlock(stack);
        int bmeta = ItemBlackHoleTalisman.getBlockMeta(stack);
        if (bBlock == null) {
            return EnumActionResult.PASS;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            if (!world.field_72995_K) {
                IItemHandler inv = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
                ItemStack toAdd = new ItemStack(bBlock, 1, bmeta);
                int maxSize = toAdd.func_77976_d();
                toAdd.func_190920_e(ItemBlackHoleTalisman.remove(stack, maxSize));
                ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)toAdd, (boolean)false);
                if (!remainder.func_190926_b()) {
                    this.add(stack, remainder.func_190916_E());
                }
            }
            return EnumActionResult.SUCCESS;
        }
        if (player.field_71075_bZ.field_75098_d || ItemBlackHoleTalisman.getBlockCount(stack) > 0) {
            ItemStack toUse = new ItemStack(bBlock, 1, bmeta);
            ItemStack saveHeldItem = player.func_184586_b(hand);
            player.func_184611_a(hand, toUse);
            EnumActionResult result = Item.func_150898_a((Block)bBlock).func_180614_a(player, world, pos, hand, side, hitX, hitY, hitZ);
            player.func_184611_a(hand, saveHeldItem);
            if (result == EnumActionResult.SUCCESS) {
                ItemBlackHoleTalisman.remove(stack, 1);
                ItemsRemainingRenderHandler.set(toUse, ItemBlackHoleTalisman.getBlockCount(stack));
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    public void func_77663_a(ItemStack itemstack, World world, Entity entity, int slot, boolean selected) {
        Block block = ItemBlackHoleTalisman.getBlock(itemstack);
        if (!entity.field_70170_p.field_72995_K && itemstack.func_77952_i() == 1 && block != null && entity instanceof EntityPlayer) {
            int i;
            EntityPlayer player = (EntityPlayer)entity;
            int meta = ItemBlackHoleTalisman.getBlockMeta(itemstack);
            int highest = -1;
            int[] counts = new int[player.field_71071_by.func_70302_i_() - player.field_71071_by.field_70460_b.size()];
            for (i = 0; i < counts.length; ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack.func_190926_b() || Item.func_150898_a((Block)block) != stack.func_77973_b() || stack.func_77952_i() != meta) continue;
                counts[i] = stack.func_190916_E();
                highest = highest == -1 ? i : (counts[i] > counts[highest] && highest > 8 ? i : highest);
            }
            if (highest != -1) {
                for (i = 0; i < counts.length; ++i) {
                    int count = counts[i];
                    if (count == 0) continue;
                    this.add(itemstack, count);
                    player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
                }
            }
        }
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack par1ItemStack) {
        Block block = ItemBlackHoleTalisman.getBlock(par1ItemStack);
        int meta = ItemBlackHoleTalisman.getBlockMeta(par1ItemStack);
        ItemStack stack = new ItemStack(block, 1, meta);
        return super.func_77653_i(par1ItemStack) + (stack.func_190926_b() ? "" : " (" + TextFormatting.GREEN + stack.func_82833_r() + TextFormatting.RESET + ")");
    }

    @Nonnull
    public ItemStack getContainerItem(@Nonnull ItemStack itemStack) {
        int count = ItemBlackHoleTalisman.getBlockCount(itemStack);
        if (count == 0) {
            return ItemStack.field_190927_a;
        }
        int extract = Math.min(64, count);
        ItemStack copy = itemStack.func_77946_l();
        ItemBlackHoleTalisman.remove(copy, extract);
        int dmg = copy.func_77952_i();
        if (dmg == 1) {
            copy.func_77964_b(0);
        }
        return copy;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return !this.getContainerItem(stack).func_190926_b();
    }

    private boolean setBlock(ItemStack stack, Block block, int meta) {
        if (Item.func_150898_a((Block)block) != Items.field_190931_a && (ItemBlackHoleTalisman.getBlock(stack) == null || ItemBlackHoleTalisman.getBlockCount(stack) == 0)) {
            ItemNBTHelper.setString(stack, TAG_BLOCK_NAME, block.getRegistryName().toString());
            ItemNBTHelper.setInt(stack, TAG_BLOCK_META, meta);
            return true;
        }
        return false;
    }

    private void add(ItemStack stack, int count) {
        int current = ItemBlackHoleTalisman.getBlockCount(stack);
        ItemBlackHoleTalisman.setCount(stack, current + count);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, World world, List<String> stacks, ITooltipFlag flags) {
        Block block = ItemBlackHoleTalisman.getBlock(par1ItemStack);
        if (block != null) {
            int count = ItemBlackHoleTalisman.getBlockCount(par1ItemStack);
            stacks.add(count + " " + I18n.func_135052_a((String)(new ItemStack(block, 1, ItemBlackHoleTalisman.getBlockMeta(par1ItemStack)).func_77977_a() + ".name"), (Object[])new Object[0]));
        }
        if (par1ItemStack.func_77952_i() == 1) {
            this.addStringToTooltip(I18n.func_135052_a((String)"botaniamisc.active", (Object[])new Object[0]), stacks);
        } else {
            this.addStringToTooltip(I18n.func_135052_a((String)"botaniamisc.inactive", (Object[])new Object[0]), stacks);
        }
    }

    void addStringToTooltip(String s, List<String> tooltip) {
        tooltip.add(s.replaceAll("&", "\u00a7"));
    }

    private static void setCount(ItemStack stack, int count) {
        ItemNBTHelper.setInt(stack, TAG_BLOCK_COUNT, count);
    }

    public static int remove(ItemStack stack, int count) {
        int current = ItemBlackHoleTalisman.getBlockCount(stack);
        ItemBlackHoleTalisman.setCount(stack, Math.max(current - count, 0));
        return Math.min(current, count);
    }

    public static String getBlockName(ItemStack stack) {
        return ItemNBTHelper.getString(stack, TAG_BLOCK_NAME, "");
    }

    @Nullable
    public static Block getBlock(ItemStack stack) {
        return Block.func_149684_b((String)ItemBlackHoleTalisman.getBlockName(stack));
    }

    public static int getBlockMeta(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_BLOCK_META, 0);
    }

    public static int getBlockCount(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_BLOCK_COUNT, 0);
    }

    @Override
    public boolean provideBlock(EntityPlayer player, ItemStack requestor, ItemStack stack, Block block, int meta, boolean doit) {
        int count;
        Block stored = ItemBlackHoleTalisman.getBlock(stack);
        int storedMeta = ItemBlackHoleTalisman.getBlockMeta(stack);
        if (stored == block && storedMeta == meta && (count = ItemBlackHoleTalisman.getBlockCount(stack)) > 0) {
            if (doit) {
                ItemBlackHoleTalisman.setCount(stack, count - 1);
            }
            return true;
        }
        return false;
    }

    @Override
    public int getBlockCount(EntityPlayer player, ItemStack requestor, ItemStack stack, Block block, int meta) {
        Block stored = ItemBlackHoleTalisman.getBlock(stack);
        int storedMeta = ItemBlackHoleTalisman.getBlockMeta(stack);
        if (stored == block && storedMeta == meta) {
            return ItemBlackHoleTalisman.getBlockCount(stack);
        }
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelHandler.registerItemAppendMeta(this, 2, "blackHoleTalisman");
    }
}

