/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.handler;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.BinaryOperator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.botania.api.internal.IManaNetwork;
import vazkii.botania.api.mana.ManaNetworkEvent;
import vazkii.botania.api.mana.TileSignature;

public final class ManaNetworkHandler
implements IManaNetwork {
    public static final ManaNetworkHandler instance = new ManaNetworkHandler();
    private final WeakHashMap<World, Set<TileSignature>> manaPools = new WeakHashMap();
    private final WeakHashMap<World, Set<TileSignature>> manaCollectors = new WeakHashMap();

    @SubscribeEvent
    public void onNetworkEvent(ManaNetworkEvent event) {
        WeakHashMap<World, Set<TileSignature>> map;
        WeakHashMap<World, Set<TileSignature>> weakHashMap = map = event.type == ManaNetworkEvent.ManaBlockType.COLLECTOR ? this.manaCollectors : this.manaPools;
        if (event.action == ManaNetworkEvent.Action.ADD) {
            this.add(map, event.tile);
        } else {
            this.remove(map, event.tile);
        }
    }

    @Override
    public void clear() {
        this.manaPools.clear();
        this.manaCollectors.clear();
    }

    @Override
    public TileEntity getClosestPool(BlockPos pos, World world, int limit) {
        if (this.manaPools.containsKey(world)) {
            return this.getClosest(this.manaPools.get(world), pos, world.field_72995_K, limit);
        }
        return null;
    }

    @Override
    public TileEntity getClosestCollector(BlockPos pos, World world, int limit) {
        if (this.manaCollectors.containsKey(world)) {
            return this.getClosest(this.manaCollectors.get(world), pos, world.field_72995_K, limit);
        }
        return null;
    }

    public boolean isCollectorIn(TileEntity tile) {
        return this.isIn(tile, this.manaCollectors);
    }

    public boolean isPoolIn(TileEntity tile) {
        return this.isIn(tile, this.manaPools);
    }

    private boolean isIn(TileEntity tile, Map<World, Set<TileSignature>> map) {
        Set<TileSignature> set = map.get(tile.func_145831_w());
        return set != null && set.contains(new TileSignature(tile, tile.func_145831_w().field_72995_K));
    }

    private TileEntity getClosest(Set<TileSignature> tiles, BlockPos pos, boolean remoteCheck, int limit) {
        return tiles.stream().filter(ts -> ts.isRemote() == remoteCheck).map(TileSignature::getTile).filter(t -> !t.func_145837_r()).filter(t -> t.func_174877_v().func_177951_i((Vec3i)pos) <= (double)(limit * limit)).reduce(BinaryOperator.minBy(Comparator.comparing(t -> t.func_174877_v().func_177951_i((Vec3i)pos), Double::compare))).orElse(null);
    }

    private void remove(Map<World, Set<TileSignature>> map, TileEntity tile) {
        World world = tile.func_145831_w();
        if (!map.containsKey(world)) {
            return;
        }
        map.get(world).remove(new TileSignature(tile, tile.func_145831_w().field_72995_K));
    }

    private void add(Map<World, Set<TileSignature>> map, TileEntity tile) {
        World world = tile.func_145831_w();
        map.putIfAbsent(world, new HashSet());
        map.get(world).add(new TileSignature(tile, tile.func_145831_w().field_72995_K));
    }

    @Override
    public Set<TileSignature> getAllCollectorsInWorld(World world) {
        return this.getAllInWorld(this.manaCollectors, world);
    }

    @Override
    public Set<TileSignature> getAllPoolsInWorld(World world) {
        return this.getAllInWorld(this.manaPools, world);
    }

    private Set<TileSignature> getAllInWorld(Map<World, Set<TileSignature>> map, World world) {
        return map.getOrDefault(world, new HashSet());
    }
}

