/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import vazkii.botania.common.block.tile.TileMod;

public class TileCocoon
extends TileMod
implements ITickable {
    private static final String TAG_TIME_PASSED = "timePassed";
    private static final String TAG_EMERALDS_GIVEN = "emeraldsGiven";
    private static final String TAG_CHORUS_FRUIT_GIVEN = "chorusFruitGiven";
    public static final int TOTAL_TIME = 2400;
    public static final int MAX_EMERALDS = 20;
    public static final int MAX_CHORUS_FRUITS = 20;
    public int timePassed;
    public int emeraldsGiven;
    public int chorusFruitGiven;

    public void func_73660_a() {
        ++this.timePassed;
        if (this.timePassed >= 2400) {
            this.hatch();
        }
    }

    private void hatch() {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175655_b(this.field_174879_c, false);
            EntityShulker entity = null;
            float villagerChance = Math.min(1.0f, (float)this.emeraldsGiven / 20.0f);
            float shulkerChance = Math.min(1.0f, (float)this.chorusFruitGiven / 20.0f);
            if (Math.random() < (double)shulkerChance) {
                entity = new EntityShulker(this.field_145850_b);
            } else if (Math.random() < (double)villagerChance) {
                EntityVillager villager = new EntityVillager(this.field_145850_b);
                VillagerRegistry.setRandomProfession((EntityVillager)villager, (Random)this.field_145850_b.field_73012_v);
                entity = villager;
            } else {
                float specialChance = 0.05f;
                if (Math.random() < (double)specialChance) {
                    int entityType = this.field_145850_b.field_73012_v.nextInt(5);
                    switch (entityType) {
                        case 0: {
                            entity = new EntityHorse(this.field_145850_b);
                            break;
                        }
                        case 1: {
                            entity = new EntityWolf(this.field_145850_b);
                            break;
                        }
                        case 2: {
                            entity = new EntityOcelot(this.field_145850_b);
                            break;
                        }
                        case 3: {
                            entity = new EntityParrot(this.field_145850_b);
                            break;
                        }
                        case 4: {
                            entity = new EntityLlama(this.field_145850_b);
                        }
                    }
                } else {
                    int entityType = this.field_145850_b.field_73012_v.nextInt(5);
                    switch (entityType) {
                        case 0: {
                            entity = new EntitySheep(this.field_145850_b);
                            break;
                        }
                        case 1: {
                            if (Math.random() < 0.01) {
                                entity = new EntityMooshroom(this.field_145850_b);
                                break;
                            }
                            entity = new EntityCow(this.field_145850_b);
                            break;
                        }
                        case 2: {
                            entity = new EntityPig(this.field_145850_b);
                            break;
                        }
                        case 3: {
                            entity = new EntityChicken(this.field_145850_b);
                            break;
                        }
                        case 4: {
                            entity = new EntityRabbit(this.field_145850_b);
                        }
                    }
                }
            }
            if (entity != null) {
                entity.func_70107_b((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5);
                if (entity instanceof EntityAgeable) {
                    ((EntityAgeable)entity).func_70873_a(-24000);
                }
                entity.func_180482_a(this.field_145850_b.func_175649_E(this.func_174877_v()), null);
                this.field_145850_b.func_72838_d((Entity)entity);
                entity.func_70656_aK();
            }
        }
    }

    @Override
    public void writePacketNBT(NBTTagCompound cmp) {
        cmp.func_74768_a(TAG_TIME_PASSED, this.timePassed);
        cmp.func_74768_a(TAG_EMERALDS_GIVEN, this.emeraldsGiven);
        cmp.func_74768_a(TAG_CHORUS_FRUIT_GIVEN, this.chorusFruitGiven);
    }

    @Override
    public void readPacketNBT(NBTTagCompound cmp) {
        this.timePassed = cmp.func_74762_e(TAG_TIME_PASSED);
        this.emeraldsGiven = cmp.func_74762_e(TAG_EMERALDS_GIVEN);
        this.chorusFruitGiven = cmp.func_74762_e(TAG_CHORUS_FRUIT_GIVEN);
    }
}

