/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.mana.IManaCollisionGhost;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.PlatformVariant;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.client.core.handler.ModelHandler;
import vazkii.botania.common.block.BlockCamo;
import vazkii.botania.common.block.tile.TileCamo;
import vazkii.botania.common.block.tile.TilePlatform;
import vazkii.botania.common.lexicon.LexiconData;

public class BlockPlatform
extends BlockCamo
implements ILexiconable,
IWandable,
IManaCollisionGhost {
    public BlockPlatform() {
        super(Material.field_151575_d, "platform");
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(BotaniaStateProps.PLATFORM_VARIANT, (Comparable)((Object)PlatformVariant.ABSTRUSE)));
    }

    @Nonnull
    public BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{BotaniaStateProps.PLATFORM_VARIANT}, new IUnlistedProperty[]{BotaniaStateProps.HELD_STATE, BotaniaStateProps.HELD_WORLD, BotaniaStateProps.HELD_POS});
    }

    public int func_176201_c(IBlockState state) {
        return ((PlatformVariant)((Object)state.func_177229_b(BotaniaStateProps.PLATFORM_VARIANT))).ordinal();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        if (meta > PlatformVariant.values().length) {
            meta = 0;
        }
        return this.func_176223_P().func_177226_a(BotaniaStateProps.PLATFORM_VARIANT, (Comparable)((Object)PlatformVariant.values()[meta]));
    }

    @Nonnull
    public IBlockState getExtendedState(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te;
        state = ((IExtendedBlockState)state).withProperty(BotaniaStateProps.HELD_WORLD, (Object)world).withProperty(BotaniaStateProps.HELD_POS, (Object)pos);
        TileEntity tileEntity = te = world instanceof ChunkCache ? ((ChunkCache)world).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : world.func_175625_s(pos);
        if (te instanceof TileCamo) {
            TileCamo tile = (TileCamo)te;
            return ((IExtendedBlockState)state).withProperty(BotaniaStateProps.HELD_STATE, (Object)tile.camoState);
        }
        return state;
    }

    public boolean canRenderInLayer(IBlockState state, @Nonnull BlockRenderLayer layer) {
        return true;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> stacks) {
        for (int i = 0; i < PlatformVariant.values().length; ++i) {
            stacks.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public void func_185477_a(IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull AxisAlignedBB par5AxisAlignedBB, @Nonnull List<AxisAlignedBB> stacks, Entity par7Entity, boolean isActualState) {
        PlatformVariant variant = (PlatformVariant)((Object)state.func_177229_b(BotaniaStateProps.PLATFORM_VARIANT));
        if (variant == PlatformVariant.INFRANGIBLE || variant == PlatformVariant.ABSTRUSE && par7Entity != null && par7Entity.field_70163_u > (double)pos.func_177956_o() + 0.9 && (!(par7Entity instanceof EntityPlayer) || !par7Entity.func_70093_af())) {
            super.func_185477_a(state, world, pos, par5AxisAlignedBB, stacks, par7Entity, isActualState);
        }
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        PlatformVariant variant = (PlatformVariant)((Object)world.func_180495_p(pos).func_177229_b(BotaniaStateProps.PLATFORM_VARIANT));
        return variant == PlatformVariant.INFRANGIBLE ? -1.0f : super.func_176195_g(state, world, pos);
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return state.func_177229_b(BotaniaStateProps.PLATFORM_VARIANT) != PlatformVariant.INFRANGIBLE;
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nonnull Entity exploder, Explosion explosion) {
        return world.func_180495_p(pos).func_177229_b(BotaniaStateProps.PLATFORM_VARIANT) != PlatformVariant.INFRANGIBLE ? super.getExplosionResistance(world, pos, exploder, explosion) : Float.MAX_VALUE;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TilePlatform();
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        PlatformVariant variant = (PlatformVariant)((Object)world.func_180495_p(pos).func_177229_b(BotaniaStateProps.PLATFORM_VARIANT));
        return variant == PlatformVariant.ABSTRUSE ? LexiconData.platform : (variant == PlatformVariant.INFRANGIBLE ? null : LexiconData.spectralPlatform);
    }

    @Override
    public boolean onUsedByWand(EntityPlayer player, ItemStack stack, World world, BlockPos pos, EnumFacing side) {
        TilePlatform tile = (TilePlatform)world.func_175625_s(pos);
        return tile.onWanded(player);
    }

    @Override
    public boolean isGhost(IBlockState state, World world, BlockPos pos) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelHandler.registerBlockToState(this, 3);
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BotaniaStateProps.PLATFORM_VARIANT}).func_178441_a());
    }
}

