/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei.crafting;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.wrapper.ICraftingRecipeWrapper;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.crafting.recipe.SpecialFloatingFlowerRecipe;
import vazkii.botania.common.item.block.ItemBlockSpecialFlower;

public class SpecialFloatingFlowerWrapper
implements ICraftingRecipeWrapper {
    private final List<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();
    private final ItemStack output;
    private final ResourceLocation name;

    public SpecialFloatingFlowerWrapper(SpecialFloatingFlowerRecipe recipe) {
        this.name = recipe.getRegistryName();
        this.inputs.add((List<ItemStack>)ImmutableList.of((Object)ItemBlockSpecialFlower.ofType(recipe.type)));
        ArrayList<ItemStack> normalFloaters = new ArrayList<ItemStack>();
        for (EnumDyeColor color : EnumDyeColor.values()) {
            normalFloaters.add(new ItemStack(ModBlocks.floatingFlower, 1, color.func_176765_a()));
        }
        this.inputs.add(normalFloaters);
        this.output = ItemBlockSpecialFlower.ofType(new ItemStack(ModBlocks.floatingSpecialFlower), recipe.type);
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, this.inputs);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)this.output);
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return this.name;
    }
}

