/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.subtile;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.internal.IManaNetwork;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.subtile.SubTileEntity;

public class SubTileFunctional
extends SubTileEntity {
    public static final int LINK_RANGE = 10;
    private static final String TAG_MANA = "mana";
    private static final String TAG_POOL_X = "poolX";
    private static final String TAG_POOL_Y = "poolY";
    private static final String TAG_POOL_Z = "poolZ";
    public int mana;
    public int redstoneSignal = 0;
    int sizeLastCheck = -1;
    TileEntity linkedPool = null;
    public int knownMana = -1;
    BlockPos cachedPoolCoordinates = null;

    public boolean acceptsRedstone() {
        return false;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.linkPool();
        if (this.linkedPool != null && this.isValidBinding()) {
            EnumFacing[] pool = (EnumFacing[])this.linkedPool;
            int manaInPool = pool.getCurrentMana();
            int manaMissing = this.getMaxMana() - this.mana;
            int manaToRemove = Math.min(manaMissing, manaInPool);
            pool.recieveMana(-manaToRemove);
            this.addMana(manaToRemove);
        }
        if (this.acceptsRedstone()) {
            this.redstoneSignal = 0;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                int redstoneSide = this.supertile.func_145831_w().func_175651_c(this.supertile.func_174877_v().func_177972_a(dir), dir);
                this.redstoneSignal = Math.max(this.redstoneSignal, redstoneSide);
            }
        }
        if (this.supertile.func_145831_w().field_72995_K) {
            double particleChance = 1.0 - (double)this.mana / (double)this.getMaxMana() / 3.5;
            Color color = new Color(this.getColor());
            if (Math.random() > particleChance) {
                BotaniaAPI.internalHandler.sparkleFX(this.supertile.func_145831_w(), (double)this.supertile.func_174877_v().func_177958_n() + 0.3 + Math.random() * 0.5, (double)this.supertile.func_174877_v().func_177956_o() + 0.5 + Math.random() * 0.5, (double)this.supertile.func_174877_v().func_177952_p() + 0.3 + Math.random() * 0.5, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)Math.random(), 5);
            }
        }
    }

    public void linkPool() {
        TileEntity tileAt;
        boolean needsNew = false;
        if (this.linkedPool == null) {
            needsNew = true;
            if (this.cachedPoolCoordinates != null) {
                needsNew = false;
                if (this.supertile.func_145831_w().func_175667_e(this.cachedPoolCoordinates)) {
                    needsNew = true;
                    tileAt = this.supertile.func_145831_w().func_175625_s(this.cachedPoolCoordinates);
                    if (tileAt != null && tileAt instanceof IManaPool && !tileAt.func_145837_r()) {
                        this.linkedPool = tileAt;
                        needsNew = false;
                    }
                    this.cachedPoolCoordinates = null;
                }
            }
        } else {
            tileAt = this.supertile.func_145831_w().func_175625_s(this.linkedPool.func_174877_v());
            if (tileAt != null && tileAt instanceof IManaPool) {
                this.linkedPool = tileAt;
            }
        }
        if (needsNew && this.ticksExisted == 1) {
            IManaNetwork network = BotaniaAPI.internalHandler.getManaNetworkInstance();
            int size = network.getAllPoolsInWorld(this.supertile.func_145831_w()).size();
            if (BotaniaAPI.internalHandler.shouldForceCheck() || size != this.sizeLastCheck) {
                this.linkedPool = network.getClosestPool(this.supertile.func_174877_v(), this.supertile.func_145831_w(), 10);
                this.sizeLastCheck = size;
            }
        }
    }

    public void linkToForcefully(TileEntity pool) {
        this.linkedPool = pool;
    }

    public void addMana(int mana) {
        this.mana = Math.min(this.getMaxMana(), this.mana + mana);
    }

    @Override
    public boolean onWanded(EntityPlayer player, ItemStack wand) {
        if (player == null) {
            return false;
        }
        this.knownMana = this.mana;
        SoundEvent evt = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(DING_SOUND_EVENT);
        if (evt != null) {
            player.func_184185_a(evt, 0.1f, 1.0f);
        }
        return super.onWanded(player, wand);
    }

    public int getMaxMana() {
        return 20;
    }

    public int getColor() {
        return 0xFFFFFF;
    }

    @Override
    public void readFromPacketNBT(NBTTagCompound cmp) {
        this.mana = cmp.func_74762_e(TAG_MANA);
        int x = cmp.func_74762_e(TAG_POOL_X);
        int y = cmp.func_74762_e(TAG_POOL_Y);
        int z = cmp.func_74762_e(TAG_POOL_Z);
        this.cachedPoolCoordinates = y < 0 ? null : new BlockPos(x, y, z);
    }

    @Override
    public void writeToPacketNBT(NBTTagCompound cmp) {
        cmp.func_74768_a(TAG_MANA, this.mana);
        if (this.cachedPoolCoordinates != null) {
            cmp.func_74768_a(TAG_POOL_X, this.cachedPoolCoordinates.func_177958_n());
            cmp.func_74768_a(TAG_POOL_Y, this.cachedPoolCoordinates.func_177956_o());
            cmp.func_74768_a(TAG_POOL_Z, this.cachedPoolCoordinates.func_177952_p());
        } else {
            int x = this.linkedPool == null ? 0 : this.linkedPool.func_174877_v().func_177958_n();
            int y = this.linkedPool == null ? -1 : this.linkedPool.func_174877_v().func_177956_o();
            int z = this.linkedPool == null ? 0 : this.linkedPool.func_174877_v().func_177952_p();
            cmp.func_74768_a(TAG_POOL_X, x);
            cmp.func_74768_a(TAG_POOL_Y, y);
            cmp.func_74768_a(TAG_POOL_Z, z);
        }
    }

    @Override
    public BlockPos getBinding() {
        if (this.linkedPool == null) {
            return null;
        }
        return this.linkedPool.func_174877_v();
    }

    @Override
    public boolean canSelect(EntityPlayer player, ItemStack wand, BlockPos pos, EnumFacing side) {
        return true;
    }

    @Override
    public boolean bindTo(EntityPlayer player, ItemStack wand, BlockPos pos, EnumFacing side) {
        TileEntity tile;
        int range = 10;
        double dist = pos.func_177951_i((Vec3i)this.supertile.func_174877_v());
        if ((double)(range *= range) >= dist && (tile = player.field_70170_p.func_175625_s(pos)) instanceof IManaPool) {
            this.linkedPool = tile;
            return true;
        }
        return false;
    }

    public boolean isValidBinding() {
        return this.linkedPool != null && this.linkedPool.func_145830_o() && !this.linkedPool.func_145837_r() && this.supertile.func_145831_w().func_175668_a(this.linkedPool.func_174877_v(), false) && this.supertile.func_145831_w().func_175625_s(this.linkedPool.func_174877_v()) == this.linkedPool;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderHUD(Minecraft mc, ScaledResolution res) {
        String name = I18n.func_135052_a((String)("tile.botania:flower." + this.getUnlocalizedName() + ".name"), (Object[])new Object[0]);
        int color = this.getColor();
        BotaniaAPI.internalHandler.drawComplexManaHUD(color, this.knownMana, this.getMaxMana(), name, res, BotaniaAPI.internalHandler.getBindDisplayForFlowerType(this), this.isValidBinding());
    }
}

