/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.mining_helmet;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="mining_helmet", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MiningHelmetConfig {
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final ClientConfig CLIENT;
    public static final ServerConfig SERVER;
    public static boolean helmetCoversFace;
    public static int zombieHelmetSpawnChance;

    private static String translate(String key) {
        return new String("mining_helmet.config." + key + ".name");
    }

    @SubscribeEvent
    public static void onLoadConfig(ModConfig.ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == CLIENT_SPEC) {
            ConfigBakery.bakeClient(config);
        } else if (config.getSpec() == SERVER_SPEC) {
            ConfigBakery.bakeServer(config);
        }
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT = (ClientConfig)pair.getLeft();
        CLIENT_SPEC = (ForgeConfigSpec)pair.getRight();
        pair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER = (ServerConfig)pair.getLeft();
        SERVER_SPEC = (ForgeConfigSpec)pair.getRight();
    }

    private static class ConfigBakery {
        private static ModConfig clientConfig;
        private static ModConfig serverConfig;

        private ConfigBakery() {
        }

        public static void bakeClient(ModConfig config) {
            clientConfig = config;
            helmetCoversFace = (Boolean)MiningHelmetConfig.CLIENT.helmetCoversFace.get();
        }

        public static void bakeServer(ModConfig config) {
            serverConfig = config;
            zombieHelmetSpawnChance = (Integer)MiningHelmetConfig.SERVER.zombieHelmetSpawnChance.get();
        }
    }

    private static class ServerConfig {
        public final ForgeConfigSpec.ConfigValue<Integer> zombieHelmetSpawnChance;

        public ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Server and Client side changes.").push("common");
            this.zombieHelmetSpawnChance = builder.translation(MiningHelmetConfig.translate("zombieHelmetSpawnChance")).comment("The chance for a Zombie to spawn with a Mining Helmet (1 in x, 0 prevents them from spawning with helmets)").define("zombieHelmetSpawnChance", (Object)20);
            builder.pop();
        }
    }

    private static class ClientConfig {
        public final ForgeConfigSpec.ConfigValue<Boolean> helmetCoversFace;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Client side changes.").push("client");
            this.helmetCoversFace = builder.translation(MiningHelmetConfig.translate("helmetCoversFace")).comment("The Mining Helmet will cover the face of whatever mob is wearing it.").define("helmetCoversFace", true);
            builder.pop();
        }
    }
}

