/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.worldgen.processors;

import com.legacy.structure_gel.StructureGelMod;
import com.legacy.structure_gel.util.Internal;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;

public class RandomStateSwapProcessor
extends StructureProcessor {
    public static final Codec<RandomStateSwapProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.field_235877_b_.fieldOf("condition").forGetter(processor -> processor.condition), (App)Codec.FLOAT.fieldOf("chance").forGetter(processor -> Float.valueOf(processor.chance)), (App)BlockState.field_235877_b_.fieldOf("change_to").forGetter(processor -> processor.changeTo)).apply((Applicative)instance, RandomStateSwapProcessor::new));
    private final BlockState condition;
    private final float chance;
    private final BlockState changeTo;

    public RandomStateSwapProcessor(BlockState condition, float chance, BlockState changeTo) {
        this.condition = condition;
        this.chance = chance;
        this.changeTo = changeTo;
    }

    public RandomStateSwapProcessor(BlockState condition, BlockState changeTo) {
        this(condition, 1.0f, changeTo);
    }

    public RandomStateSwapProcessor(BlockState condition, float chance, Block changeTo) {
        this(condition, chance, changeTo.func_176223_P());
    }

    public RandomStateSwapProcessor(BlockState condition, Block changeTo) {
        this(condition, changeTo.func_176223_P());
    }

    @Nullable
    @Internal
    public Template.BlockInfo func_230386_a_(IWorldReader worldReaderIn, BlockPos pos, BlockPos pos2, Template.BlockInfo existing, Template.BlockInfo placed, PlacementSettings settings) {
        block2: {
            block3: {
                if (placed.field_186243_b != this.condition) break block2;
                if (this.chance == 1.0f) break block3;
                Random random = new Random(MathHelper.func_180186_a((Vector3i)placed.field_186242_a));
                if (!(random.nextFloat() < this.chance)) break block2;
            }
            return new Template.BlockInfo(placed.field_186242_a, this.changeTo, null);
        }
        return placed;
    }

    @Internal
    protected IStructureProcessorType<?> func_215192_a() {
        return StructureGelMod.Processors.REPLACE_BLOCK;
    }
}

