/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.worldgen.jigsaw;

import com.legacy.structure_gel.StructureGelMod;
import com.legacy.structure_gel.worldgen.GelPlacementSettings;
import com.legacy.structure_gel.worldgen.GelTemplate;
import com.legacy.structure_gel.worldgen.jigsaw.AbstractGelStructurePiece;
import com.legacy.structure_gel.worldgen.processors.RemoveGelStructureProcessor;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Blocks;
import net.minecraft.state.properties.StructureMode;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.jigsaw.IJigsawDeserializer;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.SingleJigsawPiece;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.JigsawReplacementStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.StructureProcessorList;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class GelJigsawPiece
extends SingleJigsawPiece {
    public static final Codec<Either<ResourceLocation, Template>> POOL_CODEC = Codec.of(GelJigsawPiece::encodePool, (Decoder)ResourceLocation.field_240908_a_.map(Either::left));
    public static final Codec<GelJigsawPiece> CODEC = RecordCodecBuilder.create(instance -> instance.group(GelJigsawPiece.encodeLocaiton(), GelJigsawPiece.encodeProcessor(), (App)GelJigsawPiece.func_236848_d_(), (App)Codec.BOOL.fieldOf("maintainWater").forGetter(jigsawPiece -> jigsawPiece.maintainWater), (App)Codec.BOOL.fieldOf("ignoreEntities").forGetter(jigsawPiece -> jigsawPiece.ignoreEntities)).apply((Applicative)instance, GelJigsawPiece::new));
    private boolean maintainWater = true;
    private boolean ignoreEntities = false;

    private static <T> DataResult<T> encodePool(Either<ResourceLocation, Template> locationTemplate, DynamicOps<T> dyn, T data) {
        Optional optional = locationTemplate.left();
        return !optional.isPresent() ? DataResult.error((String)"Can not serialize a runtime pool element") : ResourceLocation.field_240908_a_.encode(optional.get(), dyn, data);
    }

    protected static <E extends GelJigsawPiece> RecordCodecBuilder<E, Supplier<StructureProcessorList>> encodeProcessor() {
        return IStructureProcessorType.field_242922_m.fieldOf("processors").forGetter(jigsawPiece -> jigsawPiece.field_214862_b);
    }

    protected static <E extends GelJigsawPiece> RecordCodecBuilder<E, Either<ResourceLocation, Template>> encodeLocaiton() {
        return POOL_CODEC.fieldOf("location").forGetter(jigsawPiece -> jigsawPiece.field_236839_c_);
    }

    public GelJigsawPiece(Either<ResourceLocation, Template> location, Supplier<StructureProcessorList> processors, JigsawPattern.PlacementBehaviour placementBehavior, boolean maintainWater, boolean ignoreEntities) {
        super(location, processors, placementBehavior);
        this.maintainWater = maintainWater;
        this.ignoreEntities = ignoreEntities;
    }

    public GelJigsawPiece maintainWater(boolean value) {
        this.maintainWater = value;
        return this;
    }

    public GelJigsawPiece setIgnoreEntities(boolean value) {
        this.ignoreEntities = value;
        return this;
    }

    protected PlacementSettings func_230379_a_(Rotation rotation, MutableBoundingBox boundingBox, boolean isLegacy) {
        GelPlacementSettings placementSettings = new GelPlacementSettings();
        placementSettings.setMaintainWater(this.maintainWater);
        placementSettings.func_186223_a(boundingBox);
        placementSettings.func_186220_a(rotation);
        placementSettings.func_215223_c(true);
        placementSettings.func_186222_a(this.ignoreEntities);
        placementSettings.func_215222_a(RemoveGelStructureProcessor.INSTANCE);
        if (!isLegacy) {
            placementSettings.func_215222_a((StructureProcessor)JigsawReplacementStructureProcessor.field_215196_a);
        }
        ((StructureProcessorList)this.field_214862_b.get()).func_242919_a().forEach(arg_0 -> ((GelPlacementSettings)placementSettings).func_215222_a(arg_0));
        this.func_214854_c().func_214937_b().forEach(arg_0 -> ((GelPlacementSettings)placementSettings).func_215222_a(arg_0));
        return placementSettings;
    }

    public boolean place(TemplateManager templateManager, ISeedReader seedReader, StructureManager structureManager, ChunkGenerator chunkGen, BlockPos pos, BlockPos pos2, Rotation rotation, MutableBoundingBox bounds, Random rand, boolean isLegacy, AbstractGelStructurePiece gelStructurePiece) {
        PlacementSettings placementSettings;
        Template template = this.getTemplate(templateManager);
        if (!new GelTemplate(template).func_237146_a_((IServerWorld)seedReader, pos, pos2, placementSettings = this.func_230379_a_(rotation, bounds, isLegacy), rand, 18)) {
            return false;
        }
        for (Template.BlockInfo blockInfo : Template.processBlockInfos((IWorld)seedReader, (BlockPos)pos, (BlockPos)pos2, (PlacementSettings)placementSettings, (List)this.func_214857_a(templateManager, pos, rotation, false), (Template)template)) {
            StructureMode mode;
            this.func_214846_a((IWorld)seedReader, blockInfo, pos, rotation, rand, bounds);
            if (blockInfo.field_186244_c == null || seedReader.func_180495_p(blockInfo.field_186242_a).func_177230_c() != Blocks.field_185779_df || (mode = StructureMode.valueOf((String)blockInfo.field_186244_c.func_74779_i("mode"))) != StructureMode.DATA) continue;
            gelStructurePiece.handleDataMarker(blockInfo.field_186244_c.func_74779_i("metadata"), blockInfo.field_186242_a, (IServerWorld)seedReader, rand, bounds);
        }
        return true;
    }

    public ResourceLocation getLocation() {
        return (ResourceLocation)this.field_236839_c_.left().get();
    }

    private Template getTemplate(TemplateManager templateManager) {
        return (Template)this.field_236839_c_.map(arg_0 -> ((TemplateManager)templateManager).func_200220_a(arg_0), Function.identity());
    }

    public IJigsawDeserializer<?> func_214853_a() {
        return StructureGelMod.JigsawDeserializers.GEL_SINGLE_POOL_ELEMENT;
    }

    public String toString() {
        return "Gel[" + this.field_236839_c_ + "]";
    }
}

