/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.mixin;

import com.legacy.structure_gel.blocks.GelPortalBlock;
import com.legacy.structure_gel.util.capability.GelCapability;
import com.legacy.structure_gel.util.capability.IGelEntity;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.block.PortalInfo;
import net.minecraft.block.PortalSize;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.TeleportationRepositioner;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public class EntityMixin {
    @Shadow
    public World field_70170_p;
    @Shadow
    protected boolean field_71087_bX;
    @Shadow
    protected int field_82153_h;
    @Shadow
    protected BlockPos field_242271_ac;

    @Inject(at={@At(value="HEAD")}, method={"updatePortal()V"}, cancellable=true)
    private void updatePortal(CallbackInfo callback) {
        IGelEntity gelEntity;
        if (this.getThis().getCapability(GelCapability.INSTANCE).isPresent() && (gelEntity = (IGelEntity)this.getThis().getCapability(GelCapability.INSTANCE).resolve().get()).getPortal() != null) {
            if (this.field_70170_p instanceof ServerWorld) {
                if (this.field_71087_bX) {
                    GelPortalBlock portal = gelEntity.getPortal();
                    int maxTime = portal.getMaxTimeInside(this.getThis());
                    ServerWorld destinationWorld = ((ServerWorld)this.field_70170_p).func_73046_m().func_71218_a(portal.getTeleporter((ServerWorld)this.field_70170_p).getOpposite());
                    if (destinationWorld != null && !this.func_184218_aH() && this.field_82153_h++ >= maxTime) {
                        this.field_70170_p.func_217381_Z().func_76320_a("portal");
                        this.field_82153_h = maxTime;
                        this.func_242279_ag();
                        Teleporter oldTeleporter = destinationWorld.field_85177_Q;
                        destinationWorld.field_85177_Q = portal.getTeleporter(destinationWorld);
                        this.func_241206_a_(destinationWorld);
                        destinationWorld.field_85177_Q = oldTeleporter;
                        this.field_70170_p.func_217381_Z().func_76319_b();
                    }
                    this.field_71087_bX = false;
                    gelEntity.setPortal(null);
                } else {
                    if (this.field_82153_h > 0) {
                        this.field_82153_h -= 4;
                    }
                    if (this.field_82153_h < 0) {
                        this.field_82153_h = 0;
                    }
                }
                this.func_184173_H();
                callback.cancel();
            }
            gelEntity.setPortal(null);
        }
    }

    @Inject(at={@At(value="RETURN", ordinal=0)}, method={"func_241829_a(Lnet/minecraft/world/server/ServerWorld;)Lnet/minecraft/block/PortalInfo;"}, cancellable=true)
    protected void func_241829_a(ServerWorld destWorld, CallbackInfoReturnable<PortalInfo> callback) {
        if (this.getThis().getCapability(GelCapability.INSTANCE).isPresent() && ((IGelEntity)this.getThis().getCapability(GelCapability.INSTANCE).resolve().get()).getPortal() != null) {
            boolean toNether = destWorld.func_234923_W_() == World.field_234919_h_;
            WorldBorder worldborder = destWorld.func_175723_af();
            double minX = Math.max(-2.9999872E7, worldborder.func_177726_b() + 16.0);
            double minZ = Math.max(-2.9999872E7, worldborder.func_177736_c() + 16.0);
            double maxX = Math.min(2.9999872E7, worldborder.func_177728_d() - 16.0);
            double maxZ = Math.min(2.9999872E7, worldborder.func_177733_e() - 16.0);
            double scaling = DimensionType.func_242715_a((DimensionType)this.field_70170_p.func_230315_m_(), (DimensionType)destWorld.func_230315_m_());
            BlockPos pos = new BlockPos(MathHelper.func_151237_a((double)(this.getThis().func_226277_ct_() * scaling), (double)minX, (double)maxX), this.getThis().func_226278_cu_(), MathHelper.func_151237_a((double)(this.getThis().func_226281_cx_() * scaling), (double)minZ, (double)maxZ));
            PortalInfo portalInfo = this.func_241830_a(destWorld, pos, toNether).map(tpResult -> {
                Vector3d motion;
                Direction.Axis direction;
                BlockState blockstate = this.field_70170_p.func_180495_p(this.field_242271_ac);
                if (blockstate.func_235901_b_((Property)BlockStateProperties.field_208199_z)) {
                    direction = (Direction.Axis)blockstate.func_177229_b((Property)BlockStateProperties.field_208199_z);
                    TeleportationRepositioner.Result motionTpResult = TeleportationRepositioner.func_243676_a((BlockPos)this.field_242271_ac, (Direction.Axis)direction, (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, bp -> this.field_70170_p.func_180495_p(bp) == blockstate);
                    motion = this.func_241839_a(direction, motionTpResult);
                } else {
                    direction = Direction.Axis.X;
                    motion = new Vector3d(0.5, 0.0, 0.0);
                }
                return PortalSize.func_242963_a((ServerWorld)destWorld, (TeleportationRepositioner.Result)tpResult, (Direction.Axis)direction, (Vector3d)motion, (EntitySize)this.getThis().func_213305_a(this.getThis().func_213283_Z()), (Vector3d)this.getThis().func_213322_ci(), (float)this.getThis().field_70177_z, (float)this.getThis().field_70125_A);
            }).orElse(null);
            callback.setReturnValue((Object)portalInfo);
        }
    }

    public Entity getThis() {
        return (Entity)this;
    }

    @Shadow
    public int func_82145_z() {
        throw new IllegalStateException("Mixin failed to shadow getMaxInPortalTime()");
    }

    @Shadow
    public boolean func_184218_aH() {
        throw new IllegalStateException("Mixin failed to shadow isPassenger()");
    }

    @Shadow
    public void func_242279_ag() {
        throw new IllegalStateException("Mixin failed to shadow func_242279_ag()");
    }

    @Shadow
    public Entity func_241206_a_(ServerWorld world) {
        throw new IllegalStateException("Mixin failed to shadow changeDimension()");
    }

    @Shadow
    public BlockPos func_233580_cy_() {
        throw new IllegalStateException("Mixin failed to shadow getPosition()");
    }

    @Shadow
    protected void func_184173_H() {
        throw new IllegalStateException("Mixin failed to shadow decrementTimeUntilPortal()");
    }

    @Shadow
    protected Optional<TeleportationRepositioner.Result> func_241830_a(ServerWorld destWorld, BlockPos pos, boolean toNether) {
        throw new IllegalStateException("Mixin failed to shadow func_241830_a()");
    }

    @Shadow
    protected Vector3d func_241839_a(Direction.Axis axis, TeleportationRepositioner.Result tpResult) {
        throw new IllegalStateException("Mixin failed to shadow func_241839_a()");
    }
}

