/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.commands;

import com.legacy.structure_gel.StructureGelMod;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.tileentity.StructureBlockTileEntity;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.server.ServerWorld;
import org.apache.logging.log4j.Logger;

public class SaveStructuresCommand {
    public static LiteralArgumentBuilder<CommandSource> get() {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"savestructures").requires(source -> source.func_197034_c(2));
        command.then(Commands.func_197056_a((String)"from", (ArgumentType)BlockPosArgument.func_197276_a()).then(Commands.func_197056_a((String)"to", (ArgumentType)BlockPosArgument.func_197276_a()).executes(context -> SaveStructuresCommand.saveStructures((CommandContext<CommandSource>)context, new MutableBoundingBox((Vector3i)BlockPosArgument.func_197273_a((CommandContext)context, (String)"from"), (Vector3i)BlockPosArgument.func_197273_a((CommandContext)context, (String)"to"))))));
        return command;
    }

    private static int saveStructures(CommandContext<CommandSource> context, MutableBoundingBox area) {
        ServerPlayerEntity player;
        ServerWorld world = ((CommandSource)context.getSource()).func_197023_e();
        ArrayList<String> savedStructures = new ArrayList<String>();
        HashMap<BlockPos, String> duplicates = new HashMap<BlockPos, String>();
        for (BlockPos pos2 : BlockPos.func_191531_b((int)area.field_78897_a, (int)area.field_78895_b, (int)area.field_78896_c, (int)area.field_78893_d, (int)area.field_78894_e, (int)area.field_78892_f)) {
            StructureBlockTileEntity tile;
            if (!(world.func_175625_s(pos2) instanceof StructureBlockTileEntity) || !(tile = (StructureBlockTileEntity)world.func_175625_s(pos2)).func_208404_d() || !tile.func_184419_m()) continue;
            if (savedStructures.contains(tile.func_189715_d())) {
                duplicates.put(new BlockPos((Vector3i)pos2), tile.func_189715_d());
            }
            savedStructures.add(tile.func_189715_d());
        }
        if (savedStructures.size() > 0) {
            if (((CommandSource)context.getSource()).func_197022_f() instanceof ServerPlayerEntity) {
                player = (ServerPlayerEntity)((CommandSource)context.getSource()).func_197022_f();
                player.func_145747_a((ITextComponent)new StringTextComponent("[Saved " + savedStructures.size() + " Structures]").func_240699_a_(TextFormatting.GREEN), Util.field_240973_b_);
                if (savedStructures.size() <= 50) {
                    savedStructures.forEach(structure -> player.func_145747_a((ITextComponent)new StringTextComponent(" - " + structure), Util.field_240973_b_));
                } else {
                    player.func_145747_a((ITextComponent)new StringTextComponent(" - Too many structures to print. Check the console."), Util.field_240973_b_);
                    StructureGelMod.LOGGER.info("Saved structures:");
                    savedStructures.forEach(arg_0 -> ((Logger)StructureGelMod.LOGGER).info(arg_0));
                }
                if (duplicates.size() > 0) {
                    player.func_145747_a((ITextComponent)new StringTextComponent("Warning: Found " + duplicates.size() + " structures with a duplicate name. Click to teleport.").func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
                    player.func_145747_a((ITextComponent)new StringTextComponent("[Duplicate Structures]").func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
                    if (duplicates.size() <= 50) {
                        duplicates.forEach((pos, structure) -> player.func_145747_a((ITextComponent)new StringTextComponent(String.format("%s at (%d, %d, %d)", structure, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())).func_240700_a_(style -> style.func_240715_a_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + pos.func_177958_n() + " " + pos.func_177956_o() + " " + pos.func_177952_p()))), Util.field_240973_b_));
                    } else {
                        player.func_145747_a((ITextComponent)new StringTextComponent(" - Too many duplicates to print. Check the console."), Util.field_240973_b_);
                        StructureGelMod.LOGGER.info("Duplicate structures:");
                        duplicates.forEach((pos, structure) -> StructureGelMod.LOGGER.info(String.format("%s /tp @s %d %d %d", structure, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())));
                    }
                }
            }
            return savedStructures.size();
        }
        player = (ServerPlayerEntity)((CommandSource)context.getSource()).func_197022_f();
        player.func_145747_a((ITextComponent)new StringTextComponent("No structures were saved."), Util.field_240973_b_);
        return 0;
    }
}

