/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class GetSpawnsCommand {
    public static LiteralArgumentBuilder<CommandSource> get() {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"getspawns").executes(context -> GetSpawnsCommand.getSpawns((CommandContext<CommandSource>)context, EntityClassification.values()));
        for (EntityClassification classification : EntityClassification.values()) {
            command.then(Commands.func_197057_a((String)classification.func_220363_a()).executes(context -> GetSpawnsCommand.getSpawns((CommandContext<CommandSource>)context, classification)));
        }
        return command;
    }

    private static int getSpawns(CommandContext<CommandSource> context, EntityClassification ... classifications) {
        LinkedHashMap<EntityClassification, List> map = new LinkedHashMap<EntityClassification, List>();
        for (EntityClassification classification2 : classifications) {
            List<MobSpawnInfo.Spawners> list2 = GetSpawnsCommand.getSpawnList(classification2, context);
            if (list2.isEmpty()) continue;
            map.put(classification2, list2);
        }
        ServerPlayerEntity player = (ServerPlayerEntity)((CommandSource)context.getSource()).func_197022_f();
        if (!map.isEmpty()) {
            player.func_145747_a((ITextComponent)new StringTextComponent("--Spawn Data--"), Util.field_240973_b_);
            map.forEach((classification, list) -> GetSpawnsCommand.printSpawns(classification, list, context));
        } else if (((CommandSource)context.getSource()).func_197022_f() instanceof ServerPlayerEntity) {
            player.func_145747_a((ITextComponent)new StringTextComponent("No spawn data."), Util.field_240973_b_);
        }
        return 1;
    }

    private static List<MobSpawnInfo.Spawners> getSpawnList(EntityClassification classification, CommandContext<CommandSource> context) {
        ServerWorld world = ((CommandSource)context.getSource()).func_197023_e();
        BlockPos pos = new BlockPos(((CommandSource)context.getSource()).func_197036_d());
        Biome biome = world.func_226691_t_(pos);
        ChunkGenerator chunkGen = world.func_72863_F().field_186029_c;
        StructureManager manager = world.func_241112_a_();
        List list = chunkGen.func_230353_a_(biome, manager, classification, pos);
        return ForgeEventFactory.getPotentialSpawns((IWorld)world, (EntityClassification)classification, (BlockPos)pos, (List)list);
    }

    private static void printSpawns(EntityClassification classification, List<MobSpawnInfo.Spawners> spawns, CommandContext<CommandSource> context) {
        if (((CommandSource)context.getSource()).func_197022_f() instanceof ServerPlayerEntity && !spawns.isEmpty()) {
            ServerPlayerEntity player = (ServerPlayerEntity)((CommandSource)context.getSource()).func_197022_f();
            player.func_145747_a((ITextComponent)new StringTextComponent("[" + classification.func_220363_a() + "]").func_240699_a_(TextFormatting.GREEN), Util.field_240973_b_);
            spawns.forEach(spawn -> player.func_145747_a((ITextComponent)new StringTextComponent(String.format(" - %s, weight:%d, min:%d, max:%d", spawn.field_242588_c.getRegistryName(), spawn.field_76292_a, spawn.field_242589_d, spawn.field_242590_e)), Util.field_240973_b_));
        }
    }
}

