/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.access_helpers;

import com.legacy.structure_gel.worldgen.structure.GelStructure;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.NoiseSettings;
import net.minecraft.world.gen.settings.ScalingSettings;
import net.minecraft.world.gen.settings.SlideSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;

public class DimensionAccessHelper {
    public static DimensionSettings newDimensionSettings(DimensionStructuresSettings structures, NoiseSettings noise, BlockState defaultBlock, BlockState defaultFluid, int bedrockRoofPos, int bedrockFloorPos, int seaLevel, boolean disableMobGeneration) {
        return new DimensionSettings(structures, noise, defaultBlock, defaultFluid, bedrockRoofPos, bedrockFloorPos, seaLevel, disableMobGeneration);
    }

    public static DimensionSettings newFloatingIslandSettings(DimensionStructuresSettings structures, BlockState defaultBlock, BlockState defaultFluid, ResourceLocation name, boolean disableMobGeneration, boolean islandNoiseOverride) {
        return DimensionSettings.func_242742_a((DimensionStructuresSettings)structures, (BlockState)defaultBlock, (BlockState)defaultFluid, (ResourceLocation)name, (boolean)disableMobGeneration, (boolean)islandNoiseOverride);
    }

    public static DimensionSettings newCavesSettings(DimensionStructuresSettings structures, BlockState defaultBlock, BlockState defaultFluid, ResourceLocation name) {
        return DimensionSettings.func_242741_a((DimensionStructuresSettings)structures, (BlockState)defaultBlock, (BlockState)defaultFluid, (ResourceLocation)name);
    }

    public static DimensionSettings newSurfaceSettings(DimensionStructuresSettings structures, boolean isAmplified, ResourceLocation name) {
        return DimensionSettings.func_242743_a((DimensionStructuresSettings)structures, (boolean)isAmplified, (ResourceLocation)name);
    }

    public static DimensionSettings newCustomSurfaceSettings(DimensionStructuresSettings structureSettingsIn, boolean isAmplified, BlockState defaultBlock, BlockState defaultFluid, ResourceLocation name) {
        return new DimensionSettings(structureSettingsIn, new NoiseSettings(256, new ScalingSettings(0.9999999814507745, 0.9999999814507745, 80.0, 160.0), new SlideSettings(-10, 3, 0), new SlideSettings(-30, 0, 0), 1, 2, 1.0, -0.46875, true, true, false, isAmplified), defaultBlock, defaultFluid, -10, 0, 63, false);
    }

    public static Map<Structure<?>, StructureSeparationSettings> separationSettingsMap(GelStructure<?> ... structures) {
        return Arrays.asList(structures).stream().collect(Collectors.toMap(s -> s, GelStructure::getSeparationSettings));
    }
}

