/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.moolands.registry;

import com.legacy.moolands.Moolands;
import com.legacy.moolands.registry.MoolandsBiomes;
import com.legacy.moolands.registry.MoolandsBlocks;
import com.legacy.moolands.world.gen.StrangeChunkGenerator;
import com.legacy.structure_gel.events.RegisterDimensionEvent;
import com.legacy.structure_gel.registrars.DimensionRegistrar;
import com.legacy.structure_gel.registrars.IRegistrar;
import com.legacy.structure_gel.util.RegistryHelper;
import java.lang.reflect.Constructor;
import java.util.OptionalLong;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.Dimension;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.FuzzedBiomeMagnifier;
import net.minecraft.world.biome.IBiomeMagnifier;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.SingleBiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.NoiseSettings;
import net.minecraft.world.gen.settings.ScalingSettings;
import net.minecraft.world.gen.settings.SlideSettings;

public class MoolandsDimensions {
    public static final RegistryKey<World> MOOLANDS = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)Moolands.locate("moolands"));
    public static final RegistryKey<DimensionSettings> MOOLANDS_NOISE_SETTINGS = RegistryKey.func_240903_a_((RegistryKey)Registry.field_243549_ar, (ResourceLocation)Moolands.locate("moolands"));
    public static final RegistryKey<DimensionType> MOOLANDS_TYPE = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239698_ad_, (ResourceLocation)Moolands.locate("moolands"));
    public static final RegistryKey<Dimension> MOOLANDS_DIM = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239700_af_, (ResourceLocation)Moolands.locate("moolands"));

    public static void init(RegisterDimensionEvent eventIn) {
        Function<RegistryKey, DimensionSettings> mooSettings = noiseSettings -> (DimensionSettings)WorldGenRegistries.field_243658_j.func_243576_d(MOOLANDS_NOISE_SETTINGS);
        BiFunction<RegisterDimensionEvent, DimensionSettings, ChunkGenerator> mooGenerator = (event, s) -> MoolandsDimensions.createStrangeChunkGenerator((Registry<Biome>)event.getBiomeRegistry(), (Registry<DimensionSettings>)event.getDimensionSettingsRegistry(), event.getSeed());
        Supplier<DimensionType> mooDimensionType = () -> MoolandsDimensions.createDimSettings(OptionalLong.empty(), false, false);
        RegistryHelper.handleRegistrar((IRegistrar)new DimensionRegistrar(eventIn, MOOLANDS.func_240901_a_(), mooDimensionType, mooSettings, mooGenerator));
    }

    public static void initNoiseSettings() {
        MoolandsDimensions.registerNoiseSettings(MOOLANDS_NOISE_SETTINGS, MoolandsDimensions.createNoiseSettings(new DimensionStructuresSettings(false), false, MoolandsBlocks.moo_rock.func_176223_P(), Blocks.field_150350_a.func_176223_P(), MOOLANDS_NOISE_SETTINGS.func_240901_a_()));
    }

    public static DimensionSettings createNoiseSettings(DimensionStructuresSettings structureSettingsIn, boolean flag1, BlockState fillerBlockIn, BlockState fluidBlockIn, ResourceLocation settingsLocationIn) {
        try {
            Constructor constructor = DimensionSettings.class.getDeclaredConstructor(DimensionStructuresSettings.class, NoiseSettings.class, BlockState.class, BlockState.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
            constructor.setAccessible(true);
            return (DimensionSettings)constructor.newInstance(structureSettingsIn, new NoiseSettings(256, new ScalingSettings(0.9999999814507745, 0.9999999814507745, 80.0, 160.0), new SlideSettings(-10, 3, 0), new SlideSettings(-30, 0, 0), 1, 2, 1.0, -0.46875, true, true, false, flag1), fillerBlockIn, fluidBlockIn, -10, 0, 63, false);
        }
        catch (Exception e) {
            Moolands.LOGGER.error("Failed to create dimension settings. This issue should be reported!");
            e.printStackTrace();
            return null;
        }
    }

    private static DimensionSettings registerNoiseSettings(RegistryKey<DimensionSettings> settingsKeyIn, DimensionSettings dimSettingsIn) {
        WorldGenRegistries.func_243664_a((Registry)WorldGenRegistries.field_243658_j, (ResourceLocation)settingsKeyIn.func_240901_a_(), (Object)dimSettingsIn);
        return dimSettingsIn;
    }

    private static ChunkGenerator createStrangeChunkGenerator(Registry<Biome> biomeRegistry, Registry<DimensionSettings> dimSettingsRegistry, long seed) {
        return new StrangeChunkGenerator((BiomeProvider)new SingleBiomeProvider((Biome)biomeRegistry.func_243576_d(MoolandsBiomes.AWKWARD_HEIGHTS_KEY)), seed, () -> (DimensionSettings)dimSettingsRegistry.func_243576_d(MOOLANDS_NOISE_SETTINGS));
    }

    public static RegistryKey<World> moolandsKey() {
        return MOOLANDS;
    }

    private static DimensionType createDimSettings(OptionalLong time, boolean ultrawarm, boolean piglinSafe) {
        return new DimensionType(time, true, false, ultrawarm, true, 1.0, false, piglinSafe, true, false, false, 256, (IBiomeMagnifier)FuzzedBiomeMagnifier.INSTANCE, BlockTags.field_241277_aC_.func_230234_a_(), DimensionType.field_242710_a, 0.0f){};
    }
}

