/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.moolands.registry;

import com.legacy.moolands.Moolands;
import com.legacy.moolands.registry.MoolandsBlocks;
import com.legacy.moolands.registry.MoolandsDimensions;
import com.legacy.moolands.registry.MoolandsEntityTypes;
import com.legacy.moolands.registry.MoolandsFeatures;
import com.legacy.moolands.registry.MoolandsRegistry;
import com.legacy.moolands.world.gen.StrangeChunkGenerator;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;
import net.minecraft.world.gen.feature.BigMushroomFeatureConfig;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.NoiseDependant;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;

public class MoolandsBiomes {
    public static final Biome AWKWARD_HEIGHTS = Builders.createAwkwardHeightsBiome();
    public static final RegistryKey<Biome> AWKWARD_HEIGHTS_KEY = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Moolands.locate("awkward_heights"));

    public static void init(RegistryEvent.Register<Biome> event) {
        MoolandsBiomes.register((IForgeRegistry<Biome>)event.getRegistry(), "awkward_heights", AWKWARD_HEIGHTS);
        MoolandsDimensions.initNoiseSettings();
        Registry.func_218325_a((Registry)Registry.field_239690_aB_, (String)"strange_noise", StrangeChunkGenerator.providerCodec);
    }

    public static void register(IForgeRegistry<Biome> registry, String key, Biome biome) {
        MoolandsRegistry.register(registry, key, biome);
    }

    public static class SurfaceBuilders {
        public static final SurfaceBuilderConfig DREAM_GRASS_DIRT_GRAVEL_CONFIG = new SurfaceBuilderConfig(MoolandsBlocks.mooland_grass_block.func_176223_P(), MoolandsBlocks.mooland_dirt.func_176223_P(), Blocks.field_150351_n.func_176223_P());
        public static final ConfiguredSurfaceBuilder<SurfaceBuilderConfig> DREAM_GRASS_SURFACE_BUILDER = SurfaceBuilder.field_215396_G.func_242929_a((ISurfaceBuilderConfig)DREAM_GRASS_DIRT_GRAVEL_CONFIG);
    }

    public static class Builders {
        public static final BlockClusterFeatureConfig TALL_GRASS = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(MoolandsBlocks.mooland_grass.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();
        public static final BlockClusterFeatureConfig SMALL_MUSHROOM_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(MoolandsBlocks.blue_mushroom.func_176223_P(), 1).func_227407_a_(MoolandsBlocks.yellow_mushroom.func_176223_P(), 1), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();

        public static Biome createAwkwardHeightsBiome() {
            MobSpawnInfo.Builder spawns = new MobSpawnInfo.Builder();
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(MoolandsEntityTypes.AWFUL_COW, 70, 3, 5));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().func_242517_a(SurfaceBuilders.DREAM_GRASS_SURFACE_BUILDER);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)MoolandsFeatures.BLUE_MUSHROOM.func_225566_b_((IFeatureConfig)new BigMushroomFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(MoolandsBlocks.blue_mushroom_block.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_196706_do.func_176223_P()), 2)).func_242733_d(130)).func_242728_a()).func_242731_b(40));
            builder.func_242513_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, MoolandsFeatures.MOOLAND_LAKE.func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(Blocks.field_150355_j.func_176223_P())).func_227228_a_(Placement.field_215006_E.func_227446_a_((IPlacementConfig)new ChanceConfig(4))));
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)TALL_GRASS).func_227228_a_(Features.Placements.field_244002_m).func_227228_a_(Placement.field_242900_d.func_227446_a_((IPlacementConfig)new NoiseDependant(-0.8, 5, 10))));
            MoolandsFeatures.addFlowers(builder, SMALL_MUSHROOM_CONFIG, 10);
            return new Biome.Builder().func_205415_a(Biome.RainType.NONE).func_205419_a(Biome.Category.NONE).func_205421_a(0.1f).func_205420_b(0.2f).func_205414_c(0.5f).func_205417_d(0.4f).func_235097_a_(new BiomeAmbience.Builder().func_242541_f(16741450).func_242540_e(16741450).func_242539_d(2851071).func_235246_b_(0xFFFFFF).func_235248_c_(0xFFFFFF).func_235239_a_(12638463).func_242539_d(Builders.ambienceChance(0.5f)).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_()).func_242458_a(spawns.func_242577_b()).func_242457_a(builder.func_242508_a()).func_242455_a();
        }

        private static int ambienceChance(float p_244206_0_) {
            float lvt_1_1_ = p_244206_0_ / 3.0f;
            lvt_1_1_ = MathHelper.func_76131_a((float)lvt_1_1_, (float)-1.0f, (float)1.0f);
            return MathHelper.func_181758_c((float)(0.62222224f - lvt_1_1_ * 0.05f), (float)(0.5f + lvt_1_1_ * 0.1f), (float)1.0f);
        }
    }
}

