/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.moolands.entities;

import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public abstract class MountableEntity
extends AnimalEntity {
    public static final DataParameter<Boolean> RIDER_SNEAKING = EntityDataManager.func_187226_a(MountableEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected float jumpPower;
    protected boolean mountJumping;
    protected boolean canJumpMidAir = false;

    public MountableEntity(EntityType<? extends MountableEntity> type, World world) {
        super(type, world);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(RIDER_SNEAKING, (Object)false);
    }

    public boolean canRiderInteract() {
        return true;
    }

    public boolean canBeRiddenInWater(Entity rider) {
        return false;
    }

    public boolean isRiderSneaking() {
        return (Boolean)this.field_70180_af.func_187225_a(RIDER_SNEAKING);
    }

    public void setRiderSneaking(boolean riderSneaking) {
        this.field_70180_af.func_187227_b(RIDER_SNEAKING, (Object)riderSneaking);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
    }

    public void func_213352_e(Vector3d vec3d) {
        Entity entity;
        double moveStrafing = vec3d.func_82615_a();
        double moveVertical = vec3d.func_82617_b();
        double moveForward = vec3d.func_82616_c();
        Entity entity2 = entity = this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
        if (entity instanceof PlayerEntity) {
            double d1;
            PlayerEntity player = (PlayerEntity)entity;
            boolean hasJumped = (Boolean)ObfuscationReflectionHelper.getPrivateValue(LivingEntity.class, (Object)player, (String)"field_70703_bu");
            this.field_70126_B = this.field_70177_z = player.field_70177_z;
            this.field_70127_C = this.field_70125_A = player.field_70125_A;
            this.field_70759_as = player.field_70759_as;
            moveStrafing = player.field_70702_br;
            moveVertical = player.field_70701_bs;
            moveForward = player.field_191988_bg;
            if (moveForward <= 0.0) {
                moveForward *= 0.25;
            }
            if (hasJumped) {
                this.onMountedJump(moveStrafing, moveForward);
            }
            if (this.jumpPower > 0.0f && !this.isMountJumping() && (this.field_70122_E || this.canJumpMidAir)) {
                this.func_213293_j(this.func_213322_ci().field_72450_a, this.getMountJumpStrength() * (double)this.jumpPower, this.func_213322_ci().field_72449_c);
                if (this.func_70644_a(Effects.field_76430_j)) {
                    this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, (double)((float)(this.func_70660_b(Effects.field_76430_j).func_76458_c() + 1) * 0.1f), 0.0));
                }
                this.setMountJumping(true);
                this.field_70160_al = true;
                this.jumpPower = 0.0f;
                if (!this.field_70170_p.field_72995_K) {
                    this.func_213315_a(MoverType.SELF, vec3d);
                }
            }
            this.func_213317_d(this.func_213322_ci().func_216372_d((double)0.35f, 1.0, (double)0.35f));
            this.field_70138_W = 1.0f;
            if (!this.field_70170_p.field_72995_K) {
                this.field_70747_aH = this.func_70689_ay() * 0.6f;
                super.func_213352_e(new Vector3d(moveStrafing, moveVertical, moveForward));
            }
            if (this.field_70122_E) {
                this.jumpPower = 0.0f;
                this.setMountJumping(false);
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d0 = this.func_226277_ct_() - this.field_70169_q;
            float f4 = MathHelper.func_76133_a((double)(d0 * d0 + (d1 = this.func_226281_cx_() - this.field_70166_s) * d1)) * 4.0f;
            if (f4 > 1.0f) {
                f4 = 1.0f;
            }
            this.field_70721_aZ += (f4 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            this.field_70138_W = 0.5f;
            this.field_70747_aH = 0.02f;
            super.func_213352_e(vec3d);
        }
    }

    public float func_70689_ay() {
        return this.getMountedMoveSpeed();
    }

    public float getMountedMoveSpeed() {
        return 0.7f;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
    }

    protected double getMountJumpStrength() {
        return 1.0;
    }

    protected void setMountJumping(boolean mountJumping) {
        this.mountJumping = mountJumping;
    }

    protected boolean isMountJumping() {
        return this.mountJumping;
    }

    public void onMountedJump(double par1, double par2) {
        this.jumpPower = 1.0f;
    }
}

