/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.conjurer_illager.entity;

import com.legacy.conjurer_illager.entity.BouncingBallEntity;
import com.legacy.conjurer_illager.entity.ThrowingCardEntity;
import com.legacy.conjurer_illager.registry.IllagerEntityTypes;
import com.legacy.conjurer_illager.registry.IllagerParticles;
import com.legacy.conjurer_illager.registry.IllagerSounds;
import com.legacy.conjurer_illager.registry.IllagerStructures;
import com.legacy.structure_gel.access_helpers.EntityAccessHelper;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SpellcastingIllagerEntity;
import net.minecraft.entity.monster.VexEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.server.ServerWorld;

public class ConjurerEntity
extends SpellcastingIllagerEntity {
    public int throwingCardCooldown = 0;

    public ConjurerEntity(EntityType<? extends ConjurerEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 15;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new CastingSpellGoal());
        this.field_70714_bg.func_75776_a(4, (Goal)new DisappearSpellGoal());
        this.field_70714_bg.func_75776_a(4, (Goal)new ThrowingCardAttackGoal());
        this.field_70714_bg.func_75776_a(5, (Goal)new BouncyBallSpellGoal());
        this.field_70714_bg.func_75776_a(6, (Goal)new BunnySpellGoal());
        this.field_70714_bg.func_75776_a(6, (Goal)new DisplaceSpellGoal());
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 15.0f, 2.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal<PlayerEntity>((MobEntity)this, PlayerEntity.class, true){

            public boolean func_75250_a() {
                List nearbyRaiders = this.field_75299_d.field_70170_p.func_217357_a(AbstractRaiderEntity.class, new AxisAlignedBB(this.field_75299_d.func_233580_cy_()).func_72314_b(25.0, 15.0, 25.0));
                return super.func_75250_a() && nearbyRaiders.size() < 2;
            }
        }.func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, false).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, false));
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal<PlayerEntity>((CreatureEntity)this, PlayerEntity.class, 7.0f, 0.6, 1.0){

            public boolean func_75250_a() {
                List nearbyRaiders = this.field_75380_a.field_70170_p.func_217357_a(AbstractRaiderEntity.class, new AxisAlignedBB(this.field_75380_a.func_233580_cy_()).func_72314_b(25.0, 15.0, 25.0));
                return super.func_75250_a() && (nearbyRaiders.size() < 2 || this.field_75380_a.func_70638_az() != null);
            }
        });
    }

    public static AttributeModifierMap.MutableAttribute registerAttributeMap() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, 0.5).func_233815_a_(Attributes.field_233819_b_, 25.0).func_233815_a_(Attributes.field_233818_a_, 120.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (worldIn instanceof ServerWorld) {
            BlockPos pos = this.func_233580_cy_();
            StructureManager strucManager = worldIn.func_201672_e().func_241112_a_();
            boolean inTheatre = strucManager.func_235010_a_(pos, false, IllagerStructures.THEATER.getStructure()).func_75069_d();
            if (!inTheatre || reason != SpawnReason.STRUCTURE || (reason == SpawnReason.SPAWN_EGG || reason == SpawnReason.COMMAND) && inTheatre) {
                this.field_70714_bg.func_75776_a(8, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.6));
            }
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.func_193082_dl() && this.field_70173_aa % 4 == 0) {
            double r = this.field_70146_Z.nextGaussian() * 0.03;
            double g = 0.08;
            double b = this.field_70146_Z.nextGaussian() * 0.03;
            float f = this.field_70761_aq * ((float)Math.PI / 180) + MathHelper.func_76134_b((float)((float)this.field_70173_aa * 0.6662f)) * 0.25f;
            float f1 = MathHelper.func_76134_b((float)f);
            float f2 = MathHelper.func_76126_a((float)f);
            BasicParticleType particle = this.field_70146_Z.nextBoolean() ? IllagerParticles.BLACK_PLAYING_CARD : IllagerParticles.RED_PLAYING_CARD;
            this.field_70170_p.func_195594_a((IParticleData)particle, this.func_226277_ct_() + (double)f1 * 0.6, this.func_226278_cu_() + 1.8, this.func_226281_cx_() + (double)f2 * 0.6, r, g, b);
            this.field_70170_p.func_195594_a((IParticleData)particle, this.func_226277_ct_() - (double)f1 * 0.6, this.func_226278_cu_() + 1.8, this.func_226281_cx_() - (double)f2 * 0.6, r, g, b);
        }
        if (this.throwingCardCooldown > 0) {
            --this.throwingCardCooldown;
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 20; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = 0.25;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                BasicParticleType particle = this.field_70146_Z.nextBoolean() ? IllagerParticles.BLACK_PLAYING_CARD : IllagerParticles.RED_PLAYING_CARD;
                this.field_70170_p.func_195594_a((IParticleData)particle, this.func_226275_c_(1.0) - d0 * 10.0, this.func_226279_cv_() - d1 * 10.0 + 1.0, this.func_226287_g_(1.0) - d2 * 10.0, d0, d1, d2);
            }
        }
    }

    public boolean func_184191_r(Entity entityIn) {
        if (entityIn == null) {
            return false;
        }
        if (entityIn == this) {
            return true;
        }
        if (super.func_184191_r(entityIn)) {
            return true;
        }
        if (entityIn instanceof VexEntity) {
            return this.func_184191_r((Entity)((VexEntity)entityIn).func_190645_o());
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).func_70668_bt() == CreatureAttribute.field_223225_d_) {
            return this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
        }
        return false;
    }

    protected float func_70647_i() {
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f + 0.9f;
    }

    protected SoundEvent func_184639_G() {
        return IllagerSounds.ENTITY_CONJURER_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return IllagerSounds.ENTITY_CONJURER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return IllagerSounds.ENTITY_CONJURER_DEATH;
    }

    protected SoundEvent func_193086_dk() {
        return IllagerSounds.ENTITY_CONJURER_CAST_SPELL;
    }

    public void func_213660_a(int p_213660_1_, boolean p_213660_2_) {
    }

    public SoundEvent func_213654_dW() {
        return IllagerSounds.ENTITY_CONJURER_CELEBRATE;
    }

    public AbstractIllagerEntity.ArmPose func_193077_p() {
        if (this.func_184614_ca().func_77973_b() == Items.field_151121_aF) {
            return AbstractIllagerEntity.ArmPose.CROSSBOW_HOLD;
        }
        return super.func_193077_p();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return source.func_180136_u() ? super.func_70097_a(source, amount) : super.func_70097_a(source, Math.min(15.0f, amount));
    }

    public boolean isEntityLooking(LivingEntity entity) {
        if (entity != null) {
            Vector3d vec3d = entity.func_70676_i(1.0f).func_72432_b();
            Vector3d vec3d1 = new Vector3d(this.func_226277_ct_() - entity.func_226277_ct_(), this.func_174813_aQ().field_72338_b + (double)this.func_70047_e() - (entity.func_226278_cu_() + (double)entity.func_70047_e()), this.func_226281_cx_() - entity.func_226281_cx_());
            double d0 = vec3d1.func_72433_c();
            double d1 = vec3d.func_72430_b(vec3d1 = vec3d1.func_72432_b());
            return !(d1 < 1.0 / d0);
        }
        return false;
    }

    class ThrowingCardAttackGoal
    extends Goal {
        public int cardThrows = 0;

        private ThrowingCardAttackGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return ConjurerEntity.this.throwingCardCooldown <= 0 && this.cardThrows < 10 && !ConjurerEntity.this.func_193082_dl() && ConjurerEntity.this.func_70638_az() != null && ConjurerEntity.this.func_70638_az().field_70170_p.field_73012_v.nextInt(20) == 0;
        }

        public void func_75251_c() {
            super.func_75251_c();
            this.cardThrows = 0;
            ConjurerEntity.this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
        }

        public boolean func_75253_b() {
            return ConjurerEntity.this.func_70638_az() != null && !ConjurerEntity.this.func_193082_dl() && this.cardThrows < 10;
        }

        public void func_75249_e() {
            super.func_75249_e();
            ConjurerEntity.this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151121_aF));
        }

        public void func_75246_d() {
            super.func_75246_d();
            ConjurerEntity conjurer = ConjurerEntity.this;
            if (conjurer.field_70173_aa % 4 == 0 && this.cardThrows < 10) {
                conjurer.func_184609_a(Hand.MAIN_HAND);
                ++this.cardThrows;
                double x = ConjurerEntity.this.func_70638_az().func_226277_ct_() - ConjurerEntity.this.func_226277_ct_();
                double y = ConjurerEntity.this.func_70638_az().func_174813_aQ().field_72338_b + (double)(ConjurerEntity.this.func_70638_az().func_213302_cg() / 2.0f) - (ConjurerEntity.this.func_226278_cu_() + (double)(ConjurerEntity.this.func_213302_cg() / 2.0f));
                double z = ConjurerEntity.this.func_70638_az().func_226281_cx_() - ConjurerEntity.this.func_226281_cx_();
                Vector3d lookVector = ConjurerEntity.this.func_70676_i(1.0f);
                ThrowingCardEntity projectile = new ThrowingCardEntity(IllagerEntityTypes.THROWING_CARD, (LivingEntity)ConjurerEntity.this, ConjurerEntity.this.field_70170_p);
                Random rand = ConjurerEntity.this.field_70170_p.field_73012_v;
                projectile.func_70186_c(x, y, z, 1.2f, 0.5f);
                projectile.func_70107_b(ConjurerEntity.this.func_226277_ct_() + lookVector.field_72450_a * 1.0, ConjurerEntity.this.func_226278_cu_() + (double)(ConjurerEntity.this.func_213302_cg() / 2.0f) + (double)0.2f, ConjurerEntity.this.func_226281_cx_() + lookVector.field_72449_c * 1.0);
                conjurer.func_184185_a(SoundEvents.field_219617_ah, 1.0f, 1.0f);
                projectile.setCardType(rand.nextFloat() < 0.1f ? 2 : rand.nextInt(2));
                if (!ConjurerEntity.this.field_70170_p.field_72995_K) {
                    ConjurerEntity.this.field_70170_p.func_217376_c((Entity)projectile);
                }
                if (this.cardThrows == 9) {
                    ConjurerEntity.this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
                    conjurer.throwingCardCooldown = 200;
                }
            }
            if (ConjurerEntity.this.func_70638_az() != null) {
                ConjurerEntity.this.func_70671_ap().func_75651_a((Entity)ConjurerEntity.this.func_70638_az(), (float)ConjurerEntity.this.func_184649_cE(), (float)ConjurerEntity.this.func_70646_bf());
            }
        }

        public boolean func_220685_C_() {
            return false;
        }
    }

    class DisplaceSpellGoal
    extends SpellcastingIllagerEntity.UseSpellGoal {
        private DisplaceSpellGoal() {
            super((SpellcastingIllagerEntity)ConjurerEntity.this);
        }

        public boolean func_75250_a() {
            if (ConjurerEntity.this.func_70638_az() != null && ConjurerEntity.this.func_70644_a(Effects.field_76441_p)) {
                return super.func_75250_a();
            }
            return false;
        }

        protected int func_190869_f() {
            return 60;
        }

        protected int func_190872_i() {
            return 460;
        }

        protected void func_190868_j() {
            LivingEntity entityLiving = ConjurerEntity.this.func_70638_az();
            this.teleportEntity(entityLiving, true);
        }

        public void teleportEntity(LivingEntity entityLiving, boolean strictIn) {
            World worldIn = entityLiving.field_70170_p;
            double d0 = entityLiving.func_226277_ct_();
            double d1 = entityLiving.func_226278_cu_();
            double d2 = entityLiving.func_226281_cx_();
            for (int i = 0; i < 30; ++i) {
                BlockPos pos;
                double d3 = entityLiving.func_226277_ct_() + (entityLiving.func_70681_au().nextDouble() - 0.5) * 16.0;
                double d4 = MathHelper.func_151237_a((double)(entityLiving.func_226278_cu_() + (double)(entityLiving.func_70681_au().nextInt(5) - 2)), (double)0.0, (double)(worldIn.func_217301_I() - 1));
                double d5 = entityLiving.func_226281_cx_() + (entityLiving.func_70681_au().nextDouble() - 0.5) * 16.0;
                if (entityLiving.func_184218_aH()) {
                    entityLiving.func_184210_p();
                }
                boolean isProperBlock = !ConjurerEntity.this.field_70170_p.func_226660_f_(ConjurerEntity.this.func_233580_cy_()) ? (strictIn ? worldIn.func_180495_p((pos = new BlockPos(d3, d4, d5)).func_177977_b()).func_177230_c() == Blocks.field_196666_p || worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_203209_W || worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_209394_ag || worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150487_bG : !worldIn.func_175710_j(new BlockPos(d3, d4, d5))) : true;
                if (!isProperBlock || !entityLiving.func_213373_a(d3, d4, d5, true)) continue;
                worldIn.func_184148_a((PlayerEntity)null, d0, d1, d2, SoundEvents.field_187544_ad, SoundCategory.PLAYERS, 1.0f, 1.0f);
                entityLiving.func_184185_a(SoundEvents.field_187544_ad, 1.0f, 1.0f);
                break;
            }
        }

        protected SoundEvent func_190871_k() {
            return IllagerSounds.ENTITY_CONJURER_PREPARE_DISPLACEMENT;
        }

        protected SpellcastingIllagerEntity.SpellType func_193320_l() {
            return SpellcastingIllagerEntity.SpellType.func_193337_a((int)75);
        }
    }

    class BunnySpellGoal
    extends SpellcastingIllagerEntity.UseSpellGoal {
        private BunnySpellGoal() {
            super((SpellcastingIllagerEntity)ConjurerEntity.this);
        }

        public boolean func_75250_a() {
            List nearbyRabbits = ConjurerEntity.this.field_70170_p.func_217357_a(RabbitEntity.class, new AxisAlignedBB(ConjurerEntity.this.func_233580_cy_()).func_72314_b(25.0, 15.0, 25.0));
            if (!super.func_75250_a() || ConjurerEntity.this.func_70638_az() == null || ConjurerEntity.this.func_70644_a(Effects.field_76441_p)) {
                return false;
            }
            return super.func_75250_a() && nearbyRabbits.size() < 3;
        }

        protected int func_190869_f() {
            return 50;
        }

        protected int func_190872_i() {
            return 300;
        }

        protected void func_190868_j() {
            Vector3d lookVector = ConjurerEntity.this.func_70676_i(1.0f);
            double x = ConjurerEntity.this.func_226277_ct_() + lookVector.field_72450_a;
            double y = ConjurerEntity.this.func_226278_cu_() + ((double)(ConjurerEntity.this.func_213302_cg() / 2.0f) + 2.0);
            double z = ConjurerEntity.this.func_226281_cx_() + lookVector.field_72449_c;
            BlockPos blockpos = new BlockPos(x, y, z);
            RabbitEntity rabbit = (RabbitEntity)EntityType.field_200736_ab.func_200721_a(ConjurerEntity.this.field_70170_p);
            rabbit.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)rabbit, 1.4, true));
            rabbit.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)rabbit, new Class[0]));
            rabbit.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)rabbit, PlayerEntity.class, true));
            rabbit.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)rabbit, VillagerEntity.class, true));
            rabbit.func_110148_a(Attributes.field_233826_i_).func_111128_a(8.0);
            rabbit.func_110148_a(Attributes.field_233818_a_).func_111128_a(10.0);
            rabbit.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.45);
            rabbit.func_70624_b(ConjurerEntity.this.func_70638_az());
            EntityAccessHelper.setDeathLootTable((MobEntity)rabbit, (ResourceLocation)LootTables.field_186419_a);
            rabbit.func_175529_r(ConjurerEntity.this.field_70146_Z.nextBoolean() ? 3 : 1);
            rabbit.func_213293_j(rabbit.func_213322_ci().func_82615_a(), (double)0.3f, rabbit.func_213322_ci().func_82616_c());
            rabbit.func_174828_a(blockpos, ConjurerEntity.this.field_70759_as, ConjurerEntity.this.field_70125_A);
            rabbit.func_213309_a(0.3f, new Vector3d(0.0, 0.0, 1.0));
            rabbit.func_70606_j(10.0f);
            ConjurerEntity.this.field_70170_p.func_217376_c((Entity)rabbit);
        }

        protected SoundEvent func_190871_k() {
            return IllagerSounds.ENTITY_CONJURER_PREPARE_RABBIT;
        }

        protected SpellcastingIllagerEntity.SpellType func_193320_l() {
            return SpellcastingIllagerEntity.SpellType.func_193337_a((int)74);
        }
    }

    class BouncyBallSpellGoal
    extends SpellcastingIllagerEntity.UseSpellGoal {
        private BouncyBallSpellGoal() {
            super((SpellcastingIllagerEntity)ConjurerEntity.this);
        }

        public boolean func_75250_a() {
            return super.func_75250_a();
        }

        protected int func_190869_f() {
            return 40;
        }

        protected int func_190872_i() {
            return 220;
        }

        protected void func_190868_j() {
            double x = ConjurerEntity.this.func_70638_az().func_226277_ct_() - ConjurerEntity.this.func_226277_ct_();
            double y = ConjurerEntity.this.func_70638_az().func_174813_aQ().field_72338_b + (double)(ConjurerEntity.this.func_70638_az().func_213302_cg() / 2.0f) - (ConjurerEntity.this.func_226278_cu_() + (double)(ConjurerEntity.this.func_213302_cg() / 2.0f));
            double z = ConjurerEntity.this.func_70638_az().func_226281_cx_() - ConjurerEntity.this.func_226281_cx_();
            Vector3d lookVector = ConjurerEntity.this.func_70676_i(1.0f);
            for (int i = 0; i < 5; ++i) {
                BouncingBallEntity projectile = new BouncingBallEntity(IllagerEntityTypes.BOUNCING_BALL, (LivingEntity)ConjurerEntity.this, ConjurerEntity.this.field_70170_p);
                Random rand = ConjurerEntity.this.field_70170_p.field_73012_v;
                projectile.func_189654_d(!ConjurerEntity.this.field_70170_p.func_226660_f_(ConjurerEntity.this.func_233580_cy_()));
                projectile.func_70186_c(x + (double)(i * 5) - 10.0, y + (double)rand.nextInt(3), z, 0.5f, 1.0f);
                projectile.func_70107_b(ConjurerEntity.this.func_226277_ct_() + lookVector.field_72450_a * 1.0, ConjurerEntity.this.func_226278_cu_() + (double)(ConjurerEntity.this.func_213302_cg() / 2.0f) + (double)0.2f, ConjurerEntity.this.func_226281_cx_() + lookVector.field_72449_c * 1.0);
                projectile.setBallType(rand.nextInt(5));
                if (ConjurerEntity.this.field_70170_p.field_72995_K) continue;
                ConjurerEntity.this.field_70170_p.func_217376_c((Entity)projectile);
            }
        }

        protected SoundEvent func_190871_k() {
            return IllagerSounds.ENTITY_CONJURER_PREPARE_ATTACK;
        }

        protected SpellcastingIllagerEntity.SpellType func_193320_l() {
            return SpellcastingIllagerEntity.SpellType.func_193337_a((int)73);
        }
    }

    class DisappearSpellGoal
    extends SpellcastingIllagerEntity.UseSpellGoal {
        private DisappearSpellGoal() {
            super((SpellcastingIllagerEntity)ConjurerEntity.this);
        }

        public boolean func_75250_a() {
            return ConjurerEntity.this.func_70638_az() != null && (ConjurerEntity.this.field_70737_aN > 0 || ConjurerEntity.this.func_70032_d((Entity)ConjurerEntity.this.func_70638_az()) < 8.0f) && !ConjurerEntity.this.func_70644_a(Effects.field_76441_p) && ConjurerEntity.this.isEntityLooking(ConjurerEntity.this.func_70638_az()) && super.func_75250_a();
        }

        protected int func_190869_f() {
            return 30;
        }

        protected int func_190872_i() {
            return 200;
        }

        protected void func_190868_j() {
            ConjurerEntity.this.func_195064_c(new EffectInstance(Effects.field_76441_p, 120 + ConjurerEntity.this.field_70170_p.field_73012_v.nextInt(3) * 10, 0));
            ConjurerEntity.this.func_184185_a(IllagerSounds.ENTITY_CONJURER_DISAPPEAR, 1.0f, 1.0f);
            ConjurerEntity.this.func_70656_aK();
            if (ConjurerEntity.this.func_70638_az() == null) {
                return;
            }
            if (ConjurerEntity.this.field_70170_p.field_73012_v.nextFloat() <= 0.5f && ConjurerEntity.this.func_70032_d((Entity)ConjurerEntity.this.func_70638_az()) < 7.0f || ConjurerEntity.this.field_70737_aN > 0 || ConjurerEntity.this.func_70032_d((Entity)ConjurerEntity.this.func_70638_az()) <= 4.0f) {
                ConjurerEntity.this.func_70012_b(ConjurerEntity.this.func_70638_az().func_226277_ct_(), ConjurerEntity.this.func_70638_az().func_226278_cu_(), ConjurerEntity.this.func_70638_az().func_226281_cx_(), ConjurerEntity.this.func_70638_az().func_70079_am(), ConjurerEntity.this.func_70638_az().field_70125_A);
                ConjurerEntity.this.func_213309_a(2.0f, new Vector3d(0.0, 0.0, -4.0));
            }
        }

        protected SoundEvent func_190871_k() {
            return IllagerSounds.ENTITY_CONJURER_PREPARE_VANISH;
        }

        protected SpellcastingIllagerEntity.SpellType func_193320_l() {
            return SpellcastingIllagerEntity.SpellType.DISAPPEAR;
        }
    }

    class CastingSpellGoal
    extends SpellcastingIllagerEntity.CastingASpellGoal {
        private CastingSpellGoal() {
            super((SpellcastingIllagerEntity)ConjurerEntity.this);
        }

        public void func_75246_d() {
            if (ConjurerEntity.this.func_70638_az() != null) {
                ConjurerEntity.this.func_70671_ap().func_75651_a((Entity)ConjurerEntity.this.func_70638_az(), (float)ConjurerEntity.this.func_184649_cE(), (float)ConjurerEntity.this.func_70646_bf());
            }
        }
    }
}

