/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lava_monster.entity;

import com.legacy.lava_monster.LavaMonsterConfig;
import com.legacy.lava_monster.entity.LavaMonsterAttackGoal;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.SnowGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.SmallFireballEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class LavaMonsterEntity
extends MonsterEntity
implements IRangedAttackMob {
    public static double MAX_HEALTH = 16.0;
    public double BASE_ARMOR = LavaMonsterConfig.monsterArmor;
    public double SPAWN_CHANCE = LavaMonsterConfig.spawnChance;
    public int attackDelay = 0;
    private boolean textureInc = true;
    private byte textureTicks = 0;
    private byte textureIndex = 0;

    public LavaMonsterEntity(EntityType<? extends LavaMonsterEntity> type, World world) {
        super(type, world);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.LAVA, 0.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, 0.0f);
        this.func_184644_a(PathNodeType.OPEN, 0.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, SnowGolemEntity.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(3, (Goal)new LavaMonsterAttackGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 1.5f;
    }

    public static AttributeModifierMap.MutableAttribute registerAttributeMap() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, MAX_HEALTH).func_233815_a_(Attributes.field_233819_b_, 35.0).func_233815_a_(Attributes.field_233821_d_, (double)0.24f).func_233815_a_(Attributes.field_233823_f_, 3.0).func_233815_a_(Attributes.field_233826_i_, 2.0);
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187627_L;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187553_bI;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            this.updateTexture();
        } else {
            BlockState fire;
            if (this.func_180799_ab()) {
                this.func_213317_d(this.func_213322_ci().func_216372_d(1.9, 1.0, 1.9));
            }
            if (this.func_70638_az() != null) {
                this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 20.0f, 20.0f);
            }
            this.attackDelay = Math.max(0, this.attackDelay - 1);
            if (this.func_70026_G()) {
                this.func_70097_a(DamageSource.field_76369_e, 1.0f);
            }
            BlockPos pos = new BlockPos(MathHelper.func_76128_c((double)this.func_226277_ct_()), MathHelper.func_76128_c((double)this.func_226278_cu_()), MathHelper.func_76128_c((double)this.func_226281_cx_()));
            BlockState blockState = fire = this.func_200200_C_().func_150261_e().equalsIgnoreCase("timmy") ? Blocks.field_150480_ab.func_176223_P() : AbstractFireBlock.func_235326_a_((IBlockReader)this.field_70170_p, (BlockPos)pos);
            if (this.field_70170_p.func_175623_d(pos) && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223599_b) && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223598_a) && fire.func_196955_c((IWorldReader)this.field_70170_p, pos)) {
                this.field_70170_p.func_180501_a(pos, fire, 2);
            }
        }
        if (this.field_70146_Z.nextInt(100) == 0) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197595_F, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() + (double)this.func_213302_cg() / 2.0, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), 0.0, 0.0, 0.0);
            this.func_184185_a(SoundEvents.field_187662_cZ, 0.2f + this.field_70146_Z.nextFloat() * 0.2f, 0.9f + this.field_70146_Z.nextFloat() * 0.15f);
        }
        if (this.field_70146_Z.nextInt(200) == 0) {
            this.func_184185_a(SoundEvents.field_187656_cX, 0.2f + this.field_70146_Z.nextFloat() * 0.2f, 0.9f + this.field_70146_Z.nextFloat() * 0.15f);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source.func_76364_f() instanceof SnowballEntity) {
            return super.func_70097_a(source, Math.max(3.0f, amount));
        }
        return super.func_70097_a(source, amount);
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        SmallFireballEntity fireball = new SmallFireballEntity(this.field_70170_p, (LivingEntity)this, target.func_226277_ct_() - this.func_226277_ct_(), target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 2.0f) - this.func_226278_cu_() - (double)(this.func_213302_cg() / 2.0f), target.func_226281_cx_() - this.func_226281_cx_());
        fireball.func_70107_b(fireball.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_213302_cg() - 0.5, fireball.func_226281_cx_());
        this.func_184185_a(SoundEvents.field_187557_bK, 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)fireball);
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
    }

    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
    }

    public boolean getCanSpawnHere() {
        String[] biomeArray = LavaMonsterConfig.dimensionWhitelist.split(",");
        ResourceLocation dimLocation = this.field_70170_p.func_234923_W_().func_240901_a_();
        boolean isWhitelisted = false;
        if (!isWhitelisted) {
            for (String name : biomeArray) {
                ResourceLocation regName = new ResourceLocation(name);
                if (!dimLocation.toString().matches(regName.toString())) continue;
                isWhitelisted = true;
            }
        }
        return this.field_70146_Z.nextDouble() < this.SPAWN_CHANCE && this.field_70170_p.func_226664_a_(this.func_174813_aQ()) && this.field_70170_p.func_226665_a__((Entity)this, this.func_174813_aQ()) && isWhitelisted;
    }

    public void updateTexture() {
        this.textureTicks = (byte)(this.textureTicks + 1);
        if (this.textureTicks < 2) {
            return;
        }
        this.textureTicks = 0;
        this.textureIndex = (byte)(this.textureIndex + (this.textureInc ? 1 : -1));
        if (this.textureIndex < 0) {
            this.textureIndex = 1;
            this.textureInc = true;
        } else if (this.textureIndex > 19) {
            this.textureIndex = (byte)18;
            this.textureInc = false;
        }
    }

    public int getTextureIndex() {
        return this.textureIndex;
    }

    public ItemEntity func_70099_a(ItemStack stack, float offsetY) {
        if (stack.func_190926_b()) {
            return null;
        }
        if (this.field_70170_p.field_72995_K) {
            return null;
        }
        ItemEntity itementity = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + (double)offsetY, this.func_226281_cx_(), stack);
        itementity.func_174869_p();
        itementity.func_184224_h(true);
        if (this.captureDrops() != null) {
            this.captureDrops().add(itementity);
        } else {
            this.field_70170_p.func_217376_c((Entity)itementity);
        }
        return itementity;
    }
}

