/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lava_monster;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="lava_monster", bus=Mod.EventBusSubscriber.Bus.MOD)
public class LavaMonsterConfig {
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final ClientConfig CLIENT;
    public static final ServerConfig SERVER;
    public static double monsterArmor;
    public static double monsterRange;
    public static int attackCooldown;
    public static int attackShots;
    public static int attackSpacing;
    public static int attackWindup;
    public static boolean depthHazard;
    public static boolean flowingLava;
    public static boolean shallowLava;
    public static double spawnChance;
    public static int spawnFrequency;
    public static String dimensionWhitelist;

    private static String translate(String key) {
        return new String("lava_monster.config." + key + ".name");
    }

    @SubscribeEvent
    public static void onLoadConfig(ModConfig.ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == CLIENT_SPEC) {
            ConfigBakery.bakeClient(config);
        } else if (config.getSpec() == SERVER_SPEC) {
            ConfigBakery.bakeServer(config);
        }
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT = (ClientConfig)pair.getLeft();
        CLIENT_SPEC = (ForgeConfigSpec)pair.getRight();
        pair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER = (ServerConfig)pair.getLeft();
        SERVER_SPEC = (ForgeConfigSpec)pair.getRight();
    }

    private static class ConfigBakery {
        private static ModConfig clientConfig;
        private static ModConfig serverConfig;

        private ConfigBakery() {
        }

        public static void bakeClient(ModConfig config) {
            clientConfig = config;
        }

        public static void bakeServer(ModConfig config) {
            serverConfig = config;
            monsterArmor = (Double)LavaMonsterConfig.SERVER.monsterArmor.get();
            monsterRange = (Double)LavaMonsterConfig.SERVER.monsterRange.get();
            attackCooldown = (Integer)LavaMonsterConfig.SERVER.attackCooldown.get();
            attackShots = (Integer)LavaMonsterConfig.SERVER.attackShots.get();
            attackSpacing = (Integer)LavaMonsterConfig.SERVER.attackSpacing.get();
            attackWindup = (Integer)LavaMonsterConfig.SERVER.attackWindup.get();
            depthHazard = (Boolean)LavaMonsterConfig.SERVER.depthHazard.get();
            flowingLava = (Boolean)LavaMonsterConfig.SERVER.flowingLava.get();
            shallowLava = (Boolean)LavaMonsterConfig.SERVER.shallowLava.get();
            spawnChance = (Double)LavaMonsterConfig.SERVER.spawnChance.get();
            spawnFrequency = (Integer)LavaMonsterConfig.SERVER.spawnFrequency.get();
            dimensionWhitelist = (String)LavaMonsterConfig.SERVER.dimensionWhitelist.get();
        }
    }

    private static class ServerConfig {
        public final ForgeConfigSpec.ConfigValue<Double> monsterArmor;
        public final ForgeConfigSpec.ConfigValue<Double> monsterRange;
        public final ForgeConfigSpec.ConfigValue<Integer> attackCooldown;
        public final ForgeConfigSpec.ConfigValue<Integer> attackShots;
        public final ForgeConfigSpec.ConfigValue<Integer> attackSpacing;
        public final ForgeConfigSpec.ConfigValue<Integer> attackWindup;
        public final ForgeConfigSpec.ConfigValue<Boolean> depthHazard;
        public final ForgeConfigSpec.ConfigValue<Boolean> flowingLava;
        public final ForgeConfigSpec.ConfigValue<Boolean> shallowLava;
        public final ForgeConfigSpec.ConfigValue<String> dimensionWhitelist;
        public final ForgeConfigSpec.ConfigValue<Double> spawnChance;
        public final ForgeConfigSpec.ConfigValue<Integer> spawnFrequency;

        public ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Server and Client side changes.").push("common");
            this.monsterArmor = builder.translation(LavaMonsterConfig.translate("monsterArmor")).comment("The amount of armor lava monsters have.").define("monsterArmor", (Object)0.0);
            this.monsterRange = builder.translation(LavaMonsterConfig.translate("monsterRange")).comment("The distance a lava monster will begin attacking. (maximum of 35)").define("monsterRange", (Object)17.0);
            this.attackCooldown = builder.translation(LavaMonsterConfig.translate("attackCooldown")).comment("Ticks a monster must wait after attacking before it can start winding up again.").define("attackCooldown", (Object)80);
            this.attackShots = builder.translation(LavaMonsterConfig.translate("attackShots")).comment("Number of fireballs shot with each attack.").define("attackShots", (Object)3);
            this.attackSpacing = builder.translation(LavaMonsterConfig.translate("attackSpacing")).comment("Ticks between each fireball shot in an attack.").define("attackSpacing", (Object)6);
            this.attackWindup = builder.translation(LavaMonsterConfig.translate("attackWindup")).comment("Ticks it takes before a monster can start an attack.").define("attackWindup", (Object)60);
            this.depthHazard = builder.translation(LavaMonsterConfig.translate("depthHazard")).comment("If true, lava monsters will not spawn above layer 16.").define("depthHazard", false);
            this.flowingLava = builder.translation(LavaMonsterConfig.translate("flowingLava")).comment("If true, lava monsters do not require a source block to spawn.").define("flowingLava", false);
            this.shallowLava = builder.translation(LavaMonsterConfig.translate("shallowLava")).comment("If true, lava monsters will be able to spawn in lava one block deep.").define("shallowLava", false);
            this.spawnChance = builder.translation(LavaMonsterConfig.translate("spawnChance")).comment("The chance for a lava monster spawn attempt to be successful.").define("spawnChance", (Object)0.05);
            this.spawnFrequency = builder.translation(LavaMonsterConfig.translate("spawnFrequency")).comment("The number of ticks between each lava monster spawn attempt.").define("spawnFrequency", (Object)10);
            this.dimensionWhitelist = builder.translation(LavaMonsterConfig.translate("dimensionWhitelist")).comment("Allows you to choose which dimensions the Lava Monster spawns in. Add dimensions by their registry name/id, and separate them with commas, no spaces.").define("dimensionWhitelist", (Object)"minecraft:overworld,minecraft:the_nether,good_nights_sleep:nightmare");
            builder.pop();
        }
    }

    private static class ClientConfig {
        public ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Client side changes.").push("client");
            builder.pop();
        }
    }
}

