/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds;

import java.util.Arrays;
import java.util.Random;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import team.creative.ambientsounds.AmbientCondition;
import team.creative.ambientsounds.AmbientEngine;
import team.creative.ambientsounds.AmbientEnviroment;
import team.creative.ambientsounds.AmbientSelection;
import team.creative.ambientsounds.AmbientSoundProperties;

public class AmbientSound
extends AmbientCondition {
    private static Random rand = new Random();
    public transient double volumeSetting = 1.0;
    public String name;
    public transient String fullName;
    public ResourceLocation[] files;
    public double[] chances;
    public transient SoundStream stream1;
    public transient SoundStream stream2;
    protected transient boolean active;
    protected transient float aimedVolume;
    protected transient float currentVolume;
    protected transient float aimedPitch;
    protected transient int transition;
    protected transient int transitionTime;
    protected transient int pauseTimer = -1;
    protected transient AmbientSoundProperties currentPropertries;
    protected transient AmbientEngine engine;

    @Override
    public void init(AmbientEngine engine) {
        if (this.files == null || this.files.length == 0) {
            throw new RuntimeException("Invalid sound " + this.name + " which does not contain any sound file");
        }
        this.engine = engine;
        if (this.chances == null) {
            this.chances = new double[this.files.length];
            Arrays.fill(this.chances, 1.0 / (double)this.files.length);
        } else if (this.chances.length != this.files.length) {
            double[] newChances = new double[this.files.length];
            for (int i = 0; i < newChances.length; ++i) {
                newChances[i] = this.chances.length > i ? this.chances[i] : 1.0 / (double)this.files.length;
            }
            this.chances = newChances;
        }
    }

    protected int getRandomFile() {
        if (this.files.length == 1) {
            return 0;
        }
        return rand.nextInt(this.files.length);
    }

    protected int getRandomFileExcept(int i) {
        if (this.files.length == 2) {
            return i == 0 ? 1 : 0;
        }
        int index = rand.nextInt(this.files.length - 1);
        if (index >= i) {
            ++index;
        }
        return index;
    }

    public boolean fastTick() {
        if (this.currentVolume < this.aimedVolume) {
            this.currentVolume = (float)((double)this.currentVolume + Math.min(this.currentPropertries.fadeInVolume, (double)(this.aimedVolume - this.currentVolume)));
        } else if (this.currentVolume > this.aimedVolume) {
            this.currentVolume = (float)((double)this.currentVolume - Math.min(this.currentPropertries.fadeOutVolume, (double)(this.currentVolume - this.aimedVolume)));
        }
        if (this.isPlaying()) {
            if (this.inTransition()) {
                this.stream1.volume = Math.max(0.0, Math.min(this.stream1.volume, this.getCombinedVolume() * (1.0 - (double)this.transition / (double)this.transitionTime)));
                this.stream2.volume = Math.min(this.getCombinedVolume(), this.getCombinedVolume() * ((double)this.transition / (double)this.transitionTime));
                if (this.transition >= this.transitionTime) {
                    this.engine.soundEngine.stop(this.stream1);
                    this.stream1 = this.stream2;
                    this.stream2 = null;
                }
                ++this.transition;
            } else {
                if (this.stream1.duration == -1 && this.currentPropertries.length != null) {
                    this.stream1.duration = (int)this.currentPropertries.length.randomValue();
                } else if (this.stream1.duration > 0 && this.currentPropertries.length == null) {
                    this.stream1.duration = -1;
                }
                this.stream1.volume = this.getCombinedVolume();
                if (this.currentPropertries.length != null) {
                    if (this.currentPropertries.pause == null && this.files.length > 1) {
                        if (this.stream1.remaining() <= 0) {
                            this.transition = 0;
                            this.stream2 = this.play(this.getRandomFileExcept(this.stream1.index));
                            this.stream2.volume = 0.0;
                            this.transitionTime = this.currentPropertries.transition != null ? this.currentPropertries.transition : 60;
                        }
                    } else {
                        int fadeOutTime = (int)Math.ceil((double)this.aimedVolume / this.currentPropertries.fadeOutVolume);
                        if (this.stream1.remaining() <= 0) {
                            this.engine.soundEngine.stop(this.stream1);
                            this.stream1 = null;
                            this.pauseTimer = -1;
                        } else if (fadeOutTime > this.stream1.remaining()) {
                            this.stream1.volume = this.getCombinedVolume() * (double)this.stream1.remaining() / (double)fadeOutTime;
                        }
                    }
                }
            }
            if (this.stream1 != null) {
                if (this.stream1.pitch < (double)this.aimedPitch) {
                    this.stream1.pitch += Math.min(this.currentPropertries.fadeInPitch, (double)this.aimedPitch - this.stream1.pitch);
                } else if (this.stream1.pitch > (double)this.aimedPitch) {
                    this.stream1.pitch -= Math.min(this.currentPropertries.fadeOutPitch, this.stream1.pitch - (double)this.aimedPitch);
                }
                ++this.stream1.ticksPlayed;
            }
            if (this.stream2 != null) {
                if (this.stream2.pitch < (double)this.aimedPitch) {
                    this.stream2.pitch += Math.min(this.currentPropertries.fadeInPitch, (double)this.aimedPitch - this.stream2.pitch);
                } else if (this.stream2.pitch > (double)this.aimedPitch) {
                    this.stream2.pitch -= Math.min(this.currentPropertries.fadeOutPitch, this.stream2.pitch - (double)this.aimedPitch);
                }
                ++this.stream2.ticksPlayed;
            }
        } else {
            if (this.stream2 != null) {
                this.engine.soundEngine.stop(this.stream2);
                this.stream2 = null;
            }
            if (this.pauseTimer == -1 && this.currentPropertries.pause != null) {
                this.pauseTimer = (int)this.currentPropertries.pause.randomValue();
            }
            if (this.pauseTimer <= 0) {
                this.stream1 = this.play(this.getRandomFile());
            } else {
                --this.pauseTimer;
            }
        }
        return this.aimedVolume > 0.0f || this.currentVolume > 0.0f;
    }

    @Override
    public AmbientSelection value(AmbientEnviroment env) {
        if (this.volumeSetting == 0.0) {
            return null;
        }
        return super.value(env);
    }

    public boolean tick(AmbientEnviroment env, AmbientSelection selection) {
        if (selection != null) {
            AmbientSelection soundSelection = this.value(env);
            if (soundSelection != null) {
                AmbientSelection last = selection.getLast();
                last.subSelection = soundSelection;
                this.aimedVolume = (float)selection.getEntireVolume();
                this.currentPropertries = selection.getProperties();
                last.subSelection = null;
                this.aimedPitch = MathHelper.func_76131_a((float)this.currentPropertries.getPitch(env), (float)0.5f, (float)2.0f);
            } else {
                this.aimedVolume = 0.0f;
            }
        } else {
            this.aimedVolume = 0.0f;
        }
        return this.aimedVolume > 0.0f || this.currentVolume > 0.0f;
    }

    protected SoundStream play(int index) {
        SoundStream stream = new SoundStream(index);
        stream.pitch = this.aimedPitch;
        if (this.currentPropertries.length != null) {
            stream.duration = (int)this.currentPropertries.length.randomValue();
        }
        this.engine.soundEngine.play(stream);
        return stream;
    }

    public boolean isPlaying() {
        return this.stream1 != null;
    }

    public boolean inTransition() {
        return this.stream1 != null && this.stream2 != null;
    }

    public boolean isActive() {
        return this.active;
    }

    public void activate() {
        this.active = true;
    }

    public void deactivate() {
        this.active = false;
        if (this.stream1 != null) {
            this.engine.soundEngine.stop(this.stream1);
            this.stream1 = null;
        }
        if (this.stream2 != null) {
            this.engine.soundEngine.stop(this.stream2);
            this.stream2 = null;
        }
    }

    public void onSoundFinished() {
        if (this.stream1 != null && this.stream1.finished) {
            this.stream1 = null;
            this.pauseTimer = -1;
        } else {
            this.stream2 = null;
        }
    }

    public boolean loop() {
        return this.currentPropertries.length != null || this.currentPropertries.pause == null && this.files.length == 1;
    }

    public double getCombinedVolume() {
        return (double)this.currentVolume * this.volumeSetting;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.name);
        if (this.stream1 != null) {
            builder.append("[" + this.stream1 + "]");
        }
        if (this.stream2 != null) {
            builder.append("[" + this.stream2 + "]");
        }
        if (this.inTransition()) {
            builder.append("t: " + this.transition + "/" + this.transitionTime);
        }
        return builder.toString();
    }

    public class SoundStream
    implements ITickableSound {
        public final int index;
        public final ResourceLocation location;
        public float generatedVoume;
        public SoundEventAccessor soundeventaccessor;
        public double volume;
        public double pitch;
        public int duration = -1;
        public int ticksPlayed = 0;
        private boolean finished = false;
        private boolean playedOnce;

        public SoundStream(int index) {
            this.index = index;
            this.location = AmbientSound.this.files[index];
            this.volume = AmbientSound.this.getCombinedVolume();
            this.generatedVoume = (float)this.volume;
        }

        public boolean loop() {
            return AmbientSound.this.loop();
        }

        public int remaining() {
            return this.duration - this.ticksPlayed;
        }

        public double mute() {
            return AmbientSound.this.currentPropertries.mute * this.volume;
        }

        public void onStart() {
            this.finished = false;
            this.playedOnce = false;
        }

        public void onFinished() {
            this.finished = true;
            AmbientSound.this.onSoundFinished();
        }

        public boolean hasPlayedOnce() {
            return this.playedOnce;
        }

        public void setPlayedOnce() {
            this.playedOnce = true;
        }

        public boolean hasFinished() {
            return this.finished;
        }

        public String toString() {
            return "l:" + this.location + ",v:" + (double)Math.round(this.volume * 100.0) / 100.0 + ",i:" + this.index + ",p:" + this.pitch + ",t:" + this.ticksPlayed + ",d:" + this.duration;
        }

        public boolean func_147657_c() {
            return true;
        }

        public SoundEventAccessor func_184366_a(SoundHandler sndHandler) {
            this.soundeventaccessor = sndHandler.func_184398_a(this.location);
            return this.soundeventaccessor;
        }

        public ISound.AttenuationType func_147656_j() {
            return ISound.AttenuationType.NONE;
        }

        public SoundCategory func_184365_d() {
            return SoundCategory.AMBIENT;
        }

        public float func_147655_f() {
            return (float)this.pitch;
        }

        public int func_147652_d() {
            return 0;
        }

        public Sound func_184364_b() {
            return this.soundeventaccessor.func_148720_g();
        }

        public ResourceLocation func_147650_b() {
            return this.location;
        }

        public float func_147653_e() {
            return this.generatedVoume;
        }

        public double func_147649_g() {
            return 0.0;
        }

        public double func_147654_h() {
            return 0.0;
        }

        public double func_147651_i() {
            return 0.0;
        }

        public boolean func_147667_k() {
            return false;
        }

        public void func_73660_a() {
        }

        public boolean func_217861_m() {
            return true;
        }
    }
}

