/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;

public class ConfigTemplates {

    public static class BiomeStructureConfig
    extends StructureConfig {
        public BiomeStructureConfig(ForgeConfigSpec.Builder builder, String name, double probability, int spacing, int offset, String biomes, boolean isWhitelist) {
            super(builder, name, probability, spacing, offset);
            this.biomes(isWhitelist, biomes);
        }

        public BiomeStructureConfig(ForgeConfigSpec.Builder builder, String name, double probability, int spacing, int offset, String biomes) {
            this(builder, name, probability, spacing, offset, biomes, true);
        }
    }

    public static class StructureConfig {
        private final ForgeConfigSpec.Builder builder;
        private final String name;
        private ForgeConfigSpec.DoubleValue probability;
        private ForgeConfigSpec.IntValue spacing;
        private ForgeConfigSpec.IntValue offset;
        private ForgeConfigSpec.BooleanValue isWhitelist;
        private ForgeConfigSpec.ConfigValue<String> biomeString;
        private List<Biome> biomes = new ArrayList<Biome>();
        private Map<EntityClassification, ForgeConfigSpec.ConfigValue<String>> spawnsStrings = new HashMap<EntityClassification, ForgeConfigSpec.ConfigValue<String>>();
        private Map<EntityClassification, List<Biome.SpawnListEntry>> spawns = new HashMap<EntityClassification, List<Biome.SpawnListEntry>>();

        public StructureConfig(ForgeConfigSpec.Builder builder, String name) {
            this.builder = builder;
            this.name = name;
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onConfigLoad);
        }

        public StructureConfig(ForgeConfigSpec.Builder builder, String name, double probability, int spacing, int offset) {
            this(builder, name);
            this.probability(probability).spacing(spacing).offset(offset);
        }

        public StructureConfig probability(double probability) {
            this.probability = this.builder.comment("Chance of generating in an allowed chunk").defineInRange(this.name + ".probability", probability, 0.0, 1.0);
            return this;
        }

        public StructureConfig spacing(int spacing) {
            this.spacing = this.builder.comment("Spacing between structures").defineInRange(this.name + ".spacing", spacing, 1, Integer.MAX_VALUE);
            return this;
        }

        public StructureConfig offset(int offset) {
            this.offset = this.builder.comment("Offsets the spacing of the structures randomly").defineInRange(this.name + ".offset", offset, 0, Integer.MAX_VALUE);
            return this;
        }

        public StructureConfig biomes(boolean isWhitelist, String biomes) {
            this.biomeString = this.builder.comment("A biome filter to determine where the structure should generate. Works with the biome dictionary (#overworld) and \"not\" statements (!plains). These can be combined (!#nether). Operates in the order presented. So \"#forest, !flower_forest\" will add all forests and then remove the flower forest.").define(this.name + ".biomes", (Object)biomes);
            this.isWhitelist = this.builder.comment("How should the code treate biomes? true = whitelist, false = blacklist. Biomes defined with ! do the opposite.").define(this.name + ".is_whitelist", isWhitelist);
            return this;
        }

        public StructureConfig spawns(Map<EntityClassification, String> spawns) {
            for (EntityClassification classification : EntityClassification.values()) {
                if (!spawns.containsKey(classification)) continue;
                this.getSpawnsStrings().put(classification, (ForgeConfigSpec.ConfigValue<String>)this.builder.define(this.name + ".spawns." + classification.func_220363_a(), (Object)spawns.get(classification)));
            }
            return this;
        }

        public double getProbability() {
            return this.probability != null ? (Double)this.probability.get() : 1.0;
        }

        public int getSpacing() {
            return this.spacing != null ? (Integer)this.spacing.get() : 16;
        }

        public int getOffset() {
            return this.offset != null ? (Integer)this.offset.get() : 7;
        }

        public boolean isWhitelist() {
            return this.isWhitelist != null ? (Boolean)this.isWhitelist.get() : true;
        }

        public String getBiomeString() {
            return this.biomeString != null ? (String)this.biomeString.get() : "";
        }

        public List<Biome> getBiomes() {
            return this.biomes;
        }

        public Map<EntityClassification, ForgeConfigSpec.ConfigValue<String>> getSpawnsStrings() {
            return this.spawnsStrings != null ? this.spawnsStrings : new HashMap<EntityClassification, ForgeConfigSpec.ConfigValue<String>>();
        }

        public String getSpawnsString(EntityClassification classification) {
            return this.getSpawnsStrings().containsKey(classification) ? (String)this.getSpawnsStrings().get(classification).get() : "";
        }

        @Nullable
        public List<Biome.SpawnListEntry> getSpawnsForClassification(EntityClassification classification) {
            return this.getSpawns().get(classification);
        }

        public Map<EntityClassification, List<Biome.SpawnListEntry>> getSpawns() {
            return this.spawns;
        }

        protected void onConfigLoad(ModConfig.ModConfigEvent event) {
            this.biomes = StructureConfig.parseBiomes(this.getBiomeString());
            this.spawns = new HashMap<EntityClassification, List<Biome.SpawnListEntry>>(){
                private static final long serialVersionUID = 64168135463438L;
                {
                    for (EntityClassification EC : EntityClassification.values()) {
                        if (this.getSpawnsString(EC).isEmpty()) continue;
                        this.put(EC, StructureConfig.parseSpawns(this.getSpawnsString(EC)));
                    }
                }
            };
        }

        public boolean isBiomeAllowed(Biome biome) {
            return this.biomes.contains(biome) == this.isWhitelist();
        }

        public static List<Biome> parseBiomes(String key) {
            ArrayList<Biome> biomes = new ArrayList<Biome>();
            if (!key.isEmpty()) {
                Arrays.asList(key.replace(" ", "").split(",")).stream().forEach(s -> {
                    boolean not = s.startsWith("!");
                    boolean isTag = s.replace("!", "").startsWith("#");
                    String biomeString = s.replace("!", "").replace("#", "");
                    if (!isTag) {
                        ResourceLocation biome2 = new ResourceLocation(biomeString);
                        if (ForgeRegistries.BIOMES.containsKey(biome2)) {
                            StructureConfig.updateBiomeList(biomes, (Biome)ForgeRegistries.BIOMES.getValue(biome2), not);
                        }
                    } else if (BiomeDictionary.Type.getType((String)biomeString, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]) != null) {
                        BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.getType((String)biomeString, (BiomeDictionary.Type[])new BiomeDictionary.Type[0])).forEach(biome -> StructureConfig.updateBiomeList(biomes, biome, not));
                    }
                });
            }
            return biomes;
        }

        protected static void updateBiomeList(List<Biome> biomes, Biome biome, boolean not) {
            if (not) {
                if (biomes.contains(biome)) {
                    biomes.remove(biome);
                }
            } else if (!biomes.contains(biome)) {
                biomes.add(biome);
            }
        }

        public static List<Biome.SpawnListEntry> parseSpawns(String key) {
            ArrayList<Biome.SpawnListEntry> spawns = new ArrayList<Biome.SpawnListEntry>();
            if (!key.isEmpty()) {
                try {
                    Matcher matcher = Pattern.compile("(\\[([a-z0-9/_:[-][.]]*),\\s*([0-9]*),\\s*([0-9]*),\\s*([0-9*])\\])").matcher(key);
                    while (matcher.find()) {
                        ResourceLocation entity = new ResourceLocation(matcher.group(2));
                        if (!ForgeRegistries.ENTITIES.containsKey(entity)) continue;
                        spawns.add(new Biome.SpawnListEntry((EntityType)ForgeRegistries.ENTITIES.getValue(entity), Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)), Integer.parseInt(matcher.group(5))));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return spawns;
        }
    }
}

