/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.structures;

import com.legacy.structure_gel.access_helpers.StructureAccessHelper;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;

public abstract class GelStructure<C extends IFeatureConfig>
extends Structure<C> {
    public final Map<EntityClassification, List<Biome.SpawnListEntry>> spawns = new HashMap<EntityClassification, List<Biome.SpawnListEntry>>();

    public GelStructure(Codec<C> codec) {
        super(codec);
        MinecraftForge.EVENT_BUS.addListener(this::potentialSpawnsEvent);
        this.setLakeProof(true);
    }

    public GelStructure<C> setLakeProof(boolean lakeProof) {
        if (lakeProof) {
            StructureAccessHelper.addLakeProofStructure(this);
        } else {
            StructureAccessHelper.removeLakeProofStructure(this);
        }
        return this;
    }

    public GelStructure<C> setSpawnList(EntityClassification classification, List<Biome.SpawnListEntry> spawns) {
        this.spawns.put(classification, spawns);
        return this;
    }

    public ChunkPos func_236392_a_(StructureSeparationSettings settings, long seed, SharedSeedRandom sharedSeedRand, int x, int z) {
        int spacing = this.getSpacing();
        int gridX = x / spacing * spacing;
        int gridZ = z / spacing * spacing;
        int offset = this.getOffset() + 1;
        sharedSeedRand.func_202427_a(seed, gridX, gridZ, this.getSeed());
        int offsetX = sharedSeedRand.nextInt(offset);
        int offsetZ = sharedSeedRand.nextInt(offset);
        int gridOffsetX = gridX + offsetX;
        int gridOffsetZ = gridZ + offsetZ;
        return new ChunkPos(gridOffsetX, gridOffsetZ);
    }

    protected boolean func_230363_a_(ChunkGenerator chunkGen, BiomeProvider biomeProvider, long seed, SharedSeedRandom sharedSeedRand, int chunkPosX, int chunkPosZ, Biome biomeIn, ChunkPos chunkPos, C config) {
        sharedSeedRand.func_202427_a(seed, chunkPosX, chunkPosZ, this.getSeed());
        return sharedSeedRand.nextDouble() < this.getProbability();
    }

    public BlockPos func_236388_a_(IWorldReader worldIn, StructureManager structureManager, BlockPos startPos, int searchRadius, boolean skipExistingChunks, long seed, StructureSeparationSettings settings) {
        return super.func_236388_a_(worldIn, structureManager, startPos, searchRadius, skipExistingChunks, seed, new StructureSeparationSettings(this.getSpacing(), this.getOffset(), this.getSeed()));
    }

    public abstract int getSeed();

    public abstract double getProbability();

    public abstract int getSpacing();

    public abstract int getOffset();

    public String func_143025_a() {
        return this.getRegistryName().toString();
    }

    @Nullable
    @Deprecated
    public List<Biome.SpawnListEntry> func_202279_e() {
        return this.spawns.get(EntityClassification.MONSTER);
    }

    @Nullable
    @Deprecated
    public List<Biome.SpawnListEntry> func_214469_f() {
        return this.spawns.get(EntityClassification.CREATURE);
    }

    @Nullable
    public List<Biome.SpawnListEntry> getSpawns(EntityClassification classification) {
        switch (classification) {
            case MONSTER: {
                return this.func_202279_e();
            }
            case CREATURE: {
                return this.func_214469_f();
            }
        }
        return this.spawns.get(classification);
    }

    public void potentialSpawnsEvent(WorldEvent.PotentialSpawns event) {
        if (event.getWorld() instanceof ServerWorld && ((ServerWorld)event.getWorld()).func_241112_a_().func_235010_a_(event.getPos(), false, (Structure)this).func_75069_d() && this.getSpawns(event.getType()) != null) {
            event.getList().clear();
            event.getList().addAll(this.getSpawns(event.getType()));
        }
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }
}

