/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.legacy.structure_gel.StructureGelConfig;
import com.legacy.structure_gel.blocks.AxisStructureGelBlock;
import com.legacy.structure_gel.blocks.IStructureGel;
import com.legacy.structure_gel.blocks.StructureGelBlock;
import com.legacy.structure_gel.commands.GetSpawnsCommand;
import com.legacy.structure_gel.data.JsonStructure;
import com.legacy.structure_gel.data.StructureData;
import com.legacy.structure_gel.items.StructureGelItem;
import com.legacy.structure_gel.structures.jigsaw.GelJigsawPiece;
import com.legacy.structure_gel.structures.processors.RandomBlockSwapProcessor;
import com.legacy.structure_gel.structures.processors.RandomStateSwapProcessor;
import com.legacy.structure_gel.structures.processors.RandomTagSwapProcessor;
import com.legacy.structure_gel.structures.processors.RemoveGelStructureProcessor;
import com.legacy.structure_gel.util.RegistryHelper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.Codec;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.command.CommandSource;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.IJigsawDeserializer;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="structure_gel")
public class StructureGelMod {
    public static final String MODID = "structure_gel";
    public static final Logger LOGGER = LogManager.getLogger();

    public StructureGelMod() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, StructureGelConfig.COMMON_SPEC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientInit);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonInit);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
    }

    public void clientInit(FMLClientSetupEvent event) {
        Blocks.BLOCKS.forEach(b -> RenderTypeLookup.setRenderLayer((Block)b, (RenderType)RenderType.func_228645_f_()));
    }

    public void commonInit(FMLCommonSetupEvent event) {
        StructureRegistry.STRUCTURES.forEach(structure -> {
            if (structure instanceof JsonStructure) {
                ((JsonStructure)structure).data.biomes.forEach(biome -> RegistryHelper.addStructure(biome, (Structure<NoFeatureConfig>)structure));
            }
        });
    }

    public void registerCommands(RegisterCommandsEvent event) {
        GetSpawnsCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    public static ResourceLocation locate(String key) {
        return new ResourceLocation(MODID, key);
    }

    public static class JigsawDeserializers {
        public static IJigsawDeserializer<GelJigsawPiece> GEL_SINGLE_POOL_ELEMENT;

        protected static <P extends JigsawPiece> IJigsawDeserializer<P> register(String key, Codec<P> codec) {
            return (IJigsawDeserializer)Registry.func_218322_a((Registry)Registry.field_218365_F, (ResourceLocation)StructureGelMod.locate(key), () -> codec);
        }
    }

    public static class Processors {
        public static IStructureProcessorType<RemoveGelStructureProcessor> REMOVE_FILLER;
        public static IStructureProcessorType<RandomBlockSwapProcessor> REPLACE_BLOCK;
        public static IStructureProcessorType<RandomTagSwapProcessor> REPLACE_TAG;
        public static IStructureProcessorType<RandomStateSwapProcessor> REPLACE_STATE;

        protected static <P extends StructureProcessor> IStructureProcessorType<P> register(String key, Codec<P> codec) {
            return (IStructureProcessorType)Registry.func_218322_a((Registry)Registry.field_218364_E, (ResourceLocation)StructureGelMod.locate(key), () -> codec);
        }
    }

    @Mod.EventBusSubscriber(modid="structure_gel", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class StructureRegistry {
        public static ImmutableList<Structure<NoFeatureConfig>> STRUCTURES = ImmutableList.of();
        public static IStructurePieceType JSON_PIECE;

        @SubscribeEvent
        public static void onRegistry(RegistryEvent.Register<Structure<?>> event) {
            JSON_PIECE = RegistryHelper.registerStructurePiece(StructureGelMod.locate("json_piece"), JsonStructure.JsonPieces.Piece::new);
            StructureRegistry.registerProcessors(event);
            StructureRegistry.registerDeserializers(event);
            StructureRegistry.registerStructures(event);
        }

        private static void registerProcessors(RegistryEvent.Register<Structure<?>> event) {
            Processors.REMOVE_FILLER = Processors.register("remove_filler", RemoveGelStructureProcessor.CODEC);
            Processors.REPLACE_BLOCK = Processors.register("replace_block", RandomBlockSwapProcessor.CODEC);
            Processors.REPLACE_TAG = Processors.register("replace_tag", RandomTagSwapProcessor.CODEC);
            Processors.REPLACE_STATE = Processors.register("replace_state", RandomStateSwapProcessor.CODEC);
        }

        private static void registerDeserializers(RegistryEvent.Register<Structure<?>> event) {
            JigsawDeserializers.GEL_SINGLE_POOL_ELEMENT = JigsawDeserializers.register("gel_single_pool_element", GelJigsawPiece.CODEC);
        }

        private static void registerStructures(RegistryEvent.Register<Structure<?>> event) {
            ArrayList structures = new ArrayList();
            StructureRegistry.getJsonStructures().forEach((path, json) -> {
                try {
                    StructureData data = StructureData.parse(json, path);
                    structures.add(RegistryHelper.registerStructure(event.getRegistry(), data.registryName, new JsonStructure(data)));
                    LOGGER.info(String.format("Registered \"%s\" from \"%s\"", data.registryName, path));
                }
                catch (JsonSyntaxException e) {
                    LOGGER.error(String.format("Could not load the json structure \"%s\". It was either formatted wrong or required data is missing.", path));
                    e.printStackTrace();
                }
            });
            STRUCTURES = ImmutableList.copyOf(structures);
        }

        private static Map<String, JsonObject> getJsonStructures() {
            Gson gson = new Gson();
            HashMap<String, JsonObject> jsons = new HashMap<String, JsonObject>();
            File directory = new File("json_structures");
            if (directory.exists() && directory.isDirectory()) {
                List<String> paths = StructureRegistry.getFilePaths("json_structures");
                paths.forEach(path -> {
                    try {
                        jsons.put((String)path, (JsonObject)gson.fromJson((Reader)new FileReader((String)path), JsonObject.class));
                    }
                    catch (JsonIOException | JsonSyntaxException | FileNotFoundException e) {
                        LOGGER.error(String.format("Failed to load the structure \"%s\"", path));
                        e.printStackTrace();
                    }
                });
            }
            return jsons;
        }

        private static List<String> getFilePaths(String path) {
            ArrayList<String> paths = new ArrayList<String>();
            for (File file : new File(path).listFiles()) {
                if (!file.isDirectory()) {
                    paths.add(file.getPath());
                    continue;
                }
                StructureRegistry.getFilePaths(file.getPath());
            }
            return paths;
        }
    }

    @Mod.EventBusSubscriber(modid="structure_gel", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class Items {
        @SubscribeEvent
        public static void onRegistry(RegistryEvent.Register<Item> event) {
            Blocks.BLOCKS.forEach(b -> {
                Item cfr_ignored_0 = (Item)RegistryHelper.register(event.getRegistry(), b.getRegistryName(), new StructureGelItem((StructureGelBlock)b));
            });
        }
    }

    @Mod.EventBusSubscriber(modid="structure_gel", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class Blocks {
        public static Set<Block> BLOCKS = new LinkedHashSet<Block>();
        public static Block RED_GEL;
        public static Block BLUE_GEL;
        public static Block GREEN_GEL;
        public static Block CYAN_GEL;
        public static Block ORANGE_GEL;
        public static Block YELLOW_GEL;

        @SubscribeEvent
        public static void onRegistry(RegistryEvent.Register<Block> event) {
            IForgeRegistry registry = event.getRegistry();
            RED_GEL = Blocks.registerBlock((IForgeRegistry<Block>)registry, "red_gel", new StructureGelBlock(new IStructureGel.IBehavior[0]));
            BLUE_GEL = Blocks.registerBlock((IForgeRegistry<Block>)registry, "blue_gel", new StructureGelBlock(IStructureGel.Behavior.PHOTOSENSITIVE));
            GREEN_GEL = Blocks.registerBlock((IForgeRegistry<Block>)registry, "green_gel", new StructureGelBlock(IStructureGel.Behavior.DIAGONAL_SPREAD));
            CYAN_GEL = Blocks.registerBlock((IForgeRegistry<Block>)registry, "cyan_gel", new StructureGelBlock(IStructureGel.Behavior.PHOTOSENSITIVE, IStructureGel.Behavior.DIAGONAL_SPREAD));
            ORANGE_GEL = Blocks.registerBlock((IForgeRegistry<Block>)registry, "orange_gel", new StructureGelBlock(IStructureGel.Behavior.DYNAMIC_SPREAD_DIST));
            YELLOW_GEL = Blocks.registerBlock((IForgeRegistry<Block>)registry, "yellow_gel", new AxisStructureGelBlock(IStructureGel.Behavior.AXIS_SPREAD));
        }

        private static Block registerBlock(IForgeRegistry<Block> registry, String key, Block object) {
            BLOCKS.add(object);
            return RegistryHelper.register(registry, StructureGelMod.locate(key), object);
        }
    }
}

