/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.settings;

import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElementType;
import net.spellcraftgaming.rpghud.main.ModRPGHud;
import net.spellcraftgaming.rpghud.settings.Setting;

@Environment(value=EnvType.CLIENT)
public class SettingHudType
extends Setting {
    public final String defaultValue;
    public String value;

    public SettingHudType(String ID, String value) {
        super(ID);
        this.value = this.defaultValue = value;
    }

    public SettingHudType(String ID, HudElementType type, int defaultValueId) {
        super(ID, type);
        this.value = this.defaultValue = this.value;
    }

    @Override
    public void increment() {
        Set<String> huds = ModRPGHud.instance.huds.keySet();
        String[] keys = huds.toArray(new String[huds.size()]);
        int size = keys.length;
        for (int n = 0; n < size; ++n) {
            if (!keys[n].equals(this.value)) continue;
            if (++n == size) {
                n = 0;
            }
            this.value = keys[n];
            return;
        }
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void resetValue() {
        this.value = this.defaultValue;
    }

    @Override
    public Setting setValue(Object o) {
        if (o instanceof String) {
            this.value = (String)o;
        }
        return this;
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }
}

