/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.gui.hud.element;

import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElementType;
import net.spellcraftgaming.rpghud.main.ModRPGHud;
import net.spellcraftgaming.rpghud.settings.Settings;

@Environment(value=EnvType.CLIENT)
public abstract class HudElement {
    public static final int COLOR_RED = 0xC10000;
    public static final int COLOR_PINK = 16738740;
    public static final int COLOR_BROWN = 9127187;
    public static final int COLOR_WHITE = 0xF2F2F2;
    public static final int COLOR_ORANGE = 16745472;
    public static final int COLOR_GREEN = 3916288;
    public static final int COLOR_PURPLE = 10748144;
    public static final int COLOR_BLUE = 23490;
    public static final int COLOR_AQUA = 65535;
    public static final int COLOR_BLACK = 0x292929;
    public static final int COLOR_GREY = 0x8A8A8A;
    public static final int COLOR_YELLOW = 0xEEEE00;
    public static final int[] COLOR_DEFAULT = new int[]{0x4C4C4C, 0x3D3D3D};
    protected static final class_2960 INTERFACE = new class_2960("rpghud:textures/interface.png");
    public static final int OFFSET_PERCENT = 25;
    public static final int OFFSET_PREVIEW = 0x5A5A5A;
    protected int posX;
    protected int posY;
    protected final int defaultPosX;
    protected final int defaultPosY;
    protected int elementWidth;
    protected int elementHeight;
    protected boolean moveable;
    protected HudElementType type;
    protected class_310 mc;
    protected ModRPGHud rpgHud;
    protected Settings settings;
    protected double scale;
    protected double scaleInverted;
    public HudElementType parent;

    public HudElement(HudElementType type, int posX, int posY, int width, int height, boolean moveable) {
        this.type = type;
        this.posX = posX;
        this.posY = posY;
        this.defaultPosX = posX;
        this.defaultPosY = posY;
        this.elementWidth = width;
        this.elementHeight = height;
        this.moveable = moveable;
        this.mc = class_310.method_1551();
        this.rpgHud = ModRPGHud.instance;
        this.settings = this.rpgHud.settings;
        this.scale = 1.0;
        this.scaleInverted = 1.0 / this.scale;
        this.parent = type;
    }

    public void draw(class_332 gui, class_4587 ms, float zLevel, float partialTicks, int scaledWidth, int scaledHeight) {
        this.drawElement(gui, ms, zLevel, partialTicks, scaledWidth, scaledHeight);
    }

    public abstract void drawElement(class_332 var1, class_4587 var2, float var3, float var4, int var5, int var6);

    public int getPosX(int scaledWidth) {
        return this.posX;
    }

    public int getPosY(int scaledHeight) {
        return this.posY;
    }

    public int getWidth(int scaledWidth) {
        return this.elementWidth;
    }

    public int getHeight(int scaledHeight) {
        return this.elementHeight;
    }

    public double getScale() {
        return 1.0;
    }

    public double getInvertedScale() {
        return 1.0 / this.getScale();
    }

    public boolean isMoveable() {
        return this.moveable;
    }

    public HudElementType getType() {
        return this.type;
    }

    public boolean setPos(int posX, int posY) {
        boolean xValid = false;
        boolean yValid = false;
        if (posX >= 0 && posX < this.mc.method_22683().method_4486() - this.elementWidth) {
            xValid = true;
        }
        if (posY >= 0 && posY < this.mc.method_22683().method_4502() - this.elementHeight) {
            yValid = true;
        }
        if (xValid && yValid) {
            this.posX = posX;
            this.posY = posY;
        }
        return xValid && yValid;
    }

    public void setPositionToDefault() {
        this.posX = this.defaultPosX;
        this.posY = this.defaultPosY;
    }

    public boolean checkConditions() {
        return true;
    }

    public static void drawRect(int posX, int posY, int width, int height, int color) {
        if (color == -1) {
            return;
        }
        float f3 = color <= 0xFFFFFF && color >= 0 ? 1.0f : (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.color4f((float)f, (float)f1, (float)f2, (float)f3);
        RenderSystem.disableDepthTest();
        class_289 tessellator = class_289.method_1348();
        class_287 vertexbuffer = tessellator.method_1349();
        vertexbuffer.method_1328(7, class_290.field_1592);
        vertexbuffer.method_22912((double)posX, (double)posY + (double)height, 0.0).method_1344();
        vertexbuffer.method_22912((double)posX + (double)width, (double)posY + (double)height, 0.0).method_1344();
        vertexbuffer.method_22912((double)posX + (double)width, (double)posY, 0.0).method_1344();
        vertexbuffer.method_22912((double)posX, (double)posY, 0.0).method_1344();
        tessellator.method_1350();
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected static void drawOutline(int x, int y, int width, int height, int color) {
        HudElement.drawRect(x, y, width, 1, color);
        HudElement.drawRect(x, y, 1, height, color);
        HudElement.drawRect(x + width - 1, y, 1, height, color);
        HudElement.drawRect(x, y + height - 1, width, 1, color);
    }

    public static void drawCustomBar(int x, int y, int width, int height, double value, int colorBarLight, int colorBarDark) {
        HudElement.drawCustomBar(x, y, width, height, value, COLOR_DEFAULT[0], COLOR_DEFAULT[1], colorBarLight, colorBarDark, true, 0);
    }

    public static void drawCustomBar(int x, int y, int width, int height, double value, int colorGroundLight, int colorGroundDark, int colorBarLight, int colorBarDark) {
        HudElement.drawCustomBar(x, y, width, height, value, colorGroundLight, colorGroundDark, colorBarLight, colorBarDark, true, 0);
    }

    public static void drawCustomBar(int x, int y, int width, int height, double value, int colorGroundLight, int colorGroundDark, int colorBarLight, int colorBarDark, boolean outlined) {
        HudElement.drawCustomBar(x, y, width, height, value, colorGroundLight, colorGroundDark, colorBarLight, colorBarDark, outlined, 0);
    }

    public static void drawCustomBar(int x, int y, int width, int height, double value, int colorGroundLight, int colorGroundDark, int colorBarLight, int colorBarDark, int colorOutline) {
        HudElement.drawCustomBar(x, y, width, height, value, colorGroundLight, colorGroundDark, colorBarLight, colorBarDark, true, colorOutline);
    }

    public static void drawCustomBar(int x, int y, int width, int height, double value, int colorGroundLight, int colorGroundDark, int colorBarLight, int colorBarDark, boolean outlined, int colorOutline) {
        if (value < 0.0) {
            value = 0.0;
        } else if (value > 100.0) {
            value = 100.0;
        }
        int offset = 0;
        if (outlined) {
            offset = 1;
        }
        int filledWidth = width;
        filledWidth = width - offset * 2;
        if (filledWidth < 0) {
            filledWidth = 0;
        }
        int filledHeight = width;
        filledHeight = height - offset * 2;
        if (filledHeight < 0) {
            filledHeight = 0;
        }
        int percentFilled = (int)Math.round(value / 100.0 * (double)filledWidth);
        if (outlined) {
            HudElement.drawOutline(x, y, width, height, colorOutline);
        }
        int halfedFilledHeight = filledHeight / 2;
        HudElement.drawRect(x + offset, y + offset, percentFilled, halfedFilledHeight, colorBarLight);
        HudElement.drawRect(x + offset, y + offset + halfedFilledHeight, percentFilled, filledHeight - halfedFilledHeight, colorBarDark);
        if (filledWidth - percentFilled > 0) {
            HudElement.drawRect(x + offset + percentFilled, y + offset, filledWidth - percentFilled, halfedFilledHeight, colorGroundLight);
            HudElement.drawRect(x + offset + percentFilled, y + offset + halfedFilledHeight, filledWidth - percentFilled, filledHeight - halfedFilledHeight, colorGroundDark);
        }
    }

    public void drawTetragon(int posX1, int posX2, int posY1, int posY2, int width1, int width2, int height1, int height2, int color) {
        if (color == -1) {
            return;
        }
        if (width1 < 0) {
            width1 = 0;
        }
        if (width2 < 0) {
            width2 = 0;
        }
        float f3 = color <= 0xFFFFFF && color >= 0 ? 1.0f : (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.color4f((float)f, (float)f1, (float)f2, (float)f3);
        RenderSystem.disableDepthTest();
        class_289 tessellator = class_289.method_1348();
        class_287 vertexbuffer = tessellator.method_1349();
        vertexbuffer.method_1328(7, class_290.field_1592);
        vertexbuffer.method_22912((double)posX1, (double)posY1 + (double)height1, 0.0).method_1344();
        vertexbuffer.method_22912((double)posX2 + (double)width2, (double)posY2 + (double)height2, 0.0).method_1344();
        vertexbuffer.method_22912((double)posX1 + (double)width1, (double)posY2, 0.0).method_1344();
        vertexbuffer.method_22912((double)posX2, (double)posY1, 0.0).method_1344();
        tessellator.method_1350();
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static int offsetColorPercent(int color, int offsetPercent) {
        int colorPart = color >> 16 & 0xFF;
        if ((colorPart -= colorPart / (100 / offsetPercent)) > 255) {
            colorPart = 255;
        } else if (colorPart < 0) {
            colorPart = 0;
        }
        int colorOffset = colorPart << 16;
        colorPart = color >> 8 & 0xFF;
        colorPart -= colorPart / (100 / offsetPercent);
        if (colorPart > 255) {
            colorPart = 255;
        } else if (colorPart < 0) {
            colorPart = 0;
        }
        colorOffset += colorPart << 8;
        colorPart = color & 0xFF;
        colorPart -= colorPart / (100 / offsetPercent);
        if (colorPart > 255) {
            colorPart = 255;
        } else if (colorPart < 0) {
            colorPart = 0;
        }
        return colorOffset += colorPart;
    }

    public static int offsetColor(int color, int offset) {
        int colorPart = color >> 16 & 0xFF;
        if ((colorPart += offset >> 16 & 0xFF) > 255) {
            colorPart = 255;
        } else if (colorPart < 0) {
            colorPart = 0;
        }
        int colorOffset = colorPart << 16;
        colorPart = color >> 8 & 0xFF;
        if ((colorPart += offset >> 8 & 0xFF) > 255) {
            colorPart = 255;
        } else if (colorPart < 0) {
            colorPart = 0;
        }
        colorOffset += colorPart << 8;
        colorPart = color & 0xFF;
        if ((colorPart += offset & 0xFF) > 255) {
            colorPart = 255;
        } else if (colorPart < 0) {
            colorPart = 0;
        }
        return colorOffset += colorPart;
    }

    protected void bind(class_2960 res) {
        this.mc.method_1531().method_22813(res);
    }

    protected static class_2960 getPlayerSkin(class_746 player) {
        return player.method_3117();
    }

    protected void renderHotbarItem(int x, int y, float partialTicks, class_1657 player, class_1799 item) {
        if (!item.method_7960()) {
            float f = (float)item.method_7965() - partialTicks;
            if (f > 0.0f) {
                RenderSystem.pushMatrix();
                float f1 = 1.0f + f / 5.0f;
                RenderSystem.translatef((float)(x + 8), (float)(y + 12), (float)0.0f);
                RenderSystem.scalef((float)(1.0f / f1), (float)((f1 + 1.0f) / 2.0f), (float)1.0f);
                RenderSystem.translatef((float)(-(x + 8)), (float)(-(y + 12)), (float)0.0f);
            }
            this.mc.method_1480().method_27951((class_1309)player, item, x, y);
            if (f > 0.0f) {
                RenderSystem.popMatrix();
            }
            this.mc.method_1480().method_4025(this.mc.field_1772, item, x, y);
        }
    }

    protected void drawStringWithBackground(class_4587 ms, String text, int posX, int posY, int colorMain, int colorBackground) {
        this.mc.field_1772.method_1729(ms, text, (float)(posX + 1), (float)posY, colorBackground);
        this.mc.field_1772.method_1729(ms, text, (float)(posX - 1), (float)posY, colorBackground);
        this.mc.field_1772.method_1729(ms, text, (float)posX, (float)(posY + 1), colorBackground);
        this.mc.field_1772.method_1729(ms, text, (float)posX, (float)(posY - 1), colorBackground);
        this.mc.field_1772.method_1729(ms, text, (float)posX, (float)posY, colorMain);
        RenderSystem.enableBlend();
    }
}

