/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.gui;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.spellcraftgaming.rpghud.gui.GuiButtonTooltip;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElement;

@Environment(value=EnvType.CLIENT)
public class GuiSliderMod
extends GuiButtonTooltip {
    private EnumColor color;
    public double sliderValue = 1.0;
    public String dispString = "";
    public boolean dragging = false;
    public boolean showDecimal = true;
    public double minValue = 0.0;
    public double maxValue = 5.0;
    public int precision = 1;
    private final float valueStep;
    public int value;
    public ISlider parent = null;
    public String suffix = "";
    public boolean drawString = true;

    public GuiSliderMod(EnumColor color, int x, int y, float value, float minValueIn, float maxValue, float valueStep, class_4185.class_4241 titleIn) {
        this(color, x, y, value, minValueIn, maxValue, valueStep, null, titleIn);
    }

    public GuiSliderMod(EnumColor color, int x, int y, float value, float minValueIn, float maxValue, float valueStep, ISlider par, class_4185.class_4241 titleIn) {
        super(x, y, 150, 12, (class_2561)new class_2588(""), titleIn);
        this.color = color;
        this.sliderValue = value / 255.0f;
        this.value = (int)Math.ceil(value);
        this.minValue = minValueIn;
        this.maxValue = maxValue;
        this.valueStep = valueStep;
        if (this.showDecimal) {
            String val = Double.toString(this.sliderValue * ((double)maxValue - this.minValue) + this.minValue);
            this.precision = Math.min(val.substring(val.indexOf(".") + 1).length(), 4);
        } else {
            String val = Integer.toString((int)Math.round(this.sliderValue * ((double)maxValue - this.minValue) + this.minValue));
            this.precision = 0;
        }
        if (!this.drawString) {
            this.dispString = "";
        }
    }

    protected int method_25356(boolean p_getYImage_1_) {
        return 0;
    }

    public boolean method_25406(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        this.dragging = false;
        return super.method_25406(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    public int getValueInt() {
        return (int)Math.round(this.sliderValue * (this.maxValue - this.minValue) + this.minValue);
    }

    public int getValue() {
        return (int)Math.ceil(this.value);
    }

    public void setValue(double d) {
        this.sliderValue = (d - this.minValue) / (this.maxValue - this.minValue);
    }

    protected void method_25353(class_4587 ms, class_310 par1Minecraft, int par2, int par3) {
    }

    public void method_25348(double mouseX, double mouseY) {
        this.sliderValue = Math.ceil(class_3532.method_15350((double)(this.sliderValue * 255.0), (double)0.0, (double)255.0));
        this.updateSlider(mouseX, mouseY);
        this.dragging = true;
    }

    public void updateSlider(double mouseX, double mouseY) {
        this.sliderValue = (float)(mouseX - (double)(this.field_22760 + 4)) / (float)(this.field_22758 - 8);
        if (this.sliderValue < 0.0) {
            this.sliderValue = 0.0;
        }
        if (this.sliderValue > 1.0) {
            this.sliderValue = 1.0;
        }
        this.value = class_3532.method_15384((double)class_3532.method_15350((double)(this.sliderValue * 255.0), (double)0.0, (double)255.0));
    }

    private String getDisplayString() {
        return "#" + Integer.toHexString(this.getValue()).toUpperCase();
    }

    public void method_25394(class_4587 ms, int mouseX, int mouseY, float partial) {
        if (this.field_22764) {
            if (this.dragging) {
                this.updateSlider(mouseX, mouseY);
            }
            class_310 mc = class_310.method_1551();
            int color = 0 + (this.color == EnumColor.RED ? this.value << 16 : (this.color == EnumColor.GREEN ? this.value << 8 : this.value));
            HudElement.drawCustomBar(this.field_22760, this.field_22761, this.field_22758, this.field_22759, 100.0, color, HudElement.offsetColorPercent(color, 25));
            color = 0xE0E0E0;
            if (!this.field_22763) {
                color = 0xA0A0A0;
            } else if (this.method_25367()) {
                color = 0xFFFFA0;
            }
            String buttonText = this.getDisplayString();
            mc.method_1531().method_22813(field_22757);
            this.method_25302(ms, this.field_22760 + (int)(this.sliderValue * (double)(this.field_22758 - 8)), this.field_22761, 0, 66, 4, this.field_22759 / 2);
            this.method_25302(ms, this.field_22760 + (int)(this.sliderValue * (double)(this.field_22758 - 8)), this.field_22761 + this.field_22759 / 2, 0, 86 - this.field_22759 / 2, 4, this.field_22759 / 2);
            this.method_25302(ms, this.field_22760 + (int)(this.sliderValue * (double)(this.field_22758 - 8)) + 4, this.field_22761, 196, 66, 4, this.field_22759 / 2);
            this.method_25302(ms, this.field_22760 + (int)(this.sliderValue * (double)(this.field_22758 - 8)) + 4, this.field_22761 + this.field_22759 / 2, 196, 86 - this.field_22759 / 2, 4, this.field_22759 / 2);
            this.method_25300(ms, mc.field_1772, buttonText, this.field_22760 + this.field_22758 / 2, this.field_22761 + (this.field_22759 - 8) / 2, color);
        }
    }

    public float normalizeValue(float value) {
        return (float)class_3532.method_15350((double)(((double)this.snapToStepClamp(value) - this.maxValue) / (this.maxValue - this.minValue)), (double)0.0, (double)1.0);
    }

    public float denormalizeValue(float value) {
        return this.snapToStepClamp((float)(this.minValue + (this.maxValue - this.minValue) * (double)class_3532.method_15363((float)value, (float)0.0f, (float)1.0f)));
    }

    public float snapToStepClamp(float value) {
        value = this.snapToStep(value);
        return (float)class_3532.method_15350((double)value, (double)this.minValue, (double)this.maxValue);
    }

    private float snapToStep(float value) {
        if (this.valueStep > 0.0f) {
            value = this.valueStep * (float)Math.round(value / this.valueStep);
        }
        return value;
    }

    public static interface ISlider {
        public void onChangeSliderValue(GuiSliderMod var1);
    }

    public static enum EnumColor {
        RED,
        GREEN,
        BLUE;

    }
}

