/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.structures;

import com.legacy.structure_gel.access_helpers.StructureAccessHelper;
import com.mojang.datafixers.Dynamic;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;

public abstract class GelStructure<C extends IFeatureConfig>
extends Structure<C> {
    public GelStructure(Function<Dynamic<?>, ? extends C> configFactoryIn) {
        super(configFactoryIn);
        MinecraftForge.EVENT_BUS.addListener(this::potentialSpawnsEvent);
        this.setLakeProof(true);
    }

    public GelStructure<C> setLakeProof(boolean lakeProof) {
        if (lakeProof) {
            StructureAccessHelper.addLakeProofStructure(this);
        } else {
            StructureAccessHelper.removeLakeProofStructure(this);
        }
        return this;
    }

    protected ChunkPos func_211744_a(ChunkGenerator<?> chunkGenerator, Random random, int x, int z, int spacingOffsetsX, int spacingOffsetsZ) {
        int spacing = this.getSpacing();
        int gridX = x / spacing * spacing + spacingOffsetsX * spacing;
        int gridZ = z / spacing * spacing + spacingOffsetsZ * spacing;
        int offset = this.getOffset() + 1;
        ((SharedSeedRandom)random).func_202427_a(chunkGenerator.func_202089_c(), gridX, gridZ, this.getSeed());
        int offsetX = random.nextInt(offset);
        int offsetZ = random.nextInt(offset);
        int gridOffsetX = gridX + offsetX;
        int gridOffsetZ = gridZ + offsetZ;
        return new ChunkPos(gridOffsetX, gridOffsetZ);
    }

    public boolean func_225558_a_(BiomeManager biomeManagerIn, ChunkGenerator<?> chunkGen, Random rand, int chunkPosX, int chunkPosZ, Biome biomeIn) {
        ChunkPos chunkPos = this.func_211744_a(chunkGen, rand, chunkPosX, chunkPosZ, 0, 0);
        if (chunkPos.field_77276_a == chunkPosX && chunkPos.field_77275_b == chunkPosZ && chunkGen.func_202094_a(biomeManagerIn.func_226836_a_(new BlockPos(chunkPos.field_77276_a << 4, 0, chunkPos.field_77275_b << 4)), (Structure)this)) {
            ((SharedSeedRandom)rand).func_202427_a(chunkGen.func_202089_c(), chunkPosX, chunkPosZ, this.getSeed());
            return rand.nextDouble() < this.getProbability();
        }
        return false;
    }

    public abstract int getSeed();

    public abstract double getProbability();

    public abstract int getSpacing();

    public abstract int getOffset();

    public String func_143025_a() {
        return this.getRegistryName().toString();
    }

    @Nullable
    public List<Biome.SpawnListEntry> func_202279_e() {
        return null;
    }

    @Nullable
    public List<Biome.SpawnListEntry> func_214469_f() {
        return null;
    }

    public void potentialSpawnsEvent(WorldEvent.PotentialSpawns event) {
        if (this.func_175796_a(event.getWorld(), event.getPos())) {
            if (event.getType() == EntityClassification.MONSTER && this.func_202279_e() != null) {
                event.getList().clear();
                event.getList().addAll(this.func_202279_e());
            }
            if (event.getType() == EntityClassification.CREATURE && this.func_214469_f() != null) {
                event.getList().clear();
                event.getList().addAll(this.func_214469_f());
            }
        }
    }
}

